/*
 * Decompiled with CFR 0.152.
 */
package com.github.lotqwerty.lottweaks;

import com.github.lotqwerty.lottweaks.LotTweaks;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.StringJoiner;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class RotationHelper {
    protected static final String BLOCKGROUP_CONFFILE = "LotTweaks-BlockGroups.txt";
    public static final HashMap<IBlockState, IBlockState> BLOCK_CHAIN = new HashMap();
    public static final String[] DEFAULT_BLOCK_GROUPS = new String[]{"//VANILLA BLOCKS", "//STONE", RotationHelper.toRotateStr("minecraft:stone", 7), "//DIRT", RotationHelper.toRotateStr("minecraft:dirt", 3), "//PLANKS", RotationHelper.toRotateStr("minecraft:planks", 6), "//SAPLING", RotationHelper.toRotateStr("minecraft:sapling", 6), "//ORE series", "minecraft:gold_ore,minecraft:iron_ore,minecraft:coal_ore,minecraft:lapis_ore,minecraft:diamond_ore,minecraft:redstone_ore,minecraft:emerald_ore", "//LOG + LOG2", RotationHelper.toRotateStr("minecraft:log", 4) + ',' + RotationHelper.toRotateStr("minecraft:log2", 2), "//LEAVES + LEAVES2", RotationHelper.toRotateStr("minecraft:leaves", 4) + ',' + RotationHelper.toRotateStr("minecraft:leaves2", 2), "//SPONGE", RotationHelper.toRotateStr("minecraft:sponge", 2), "//SANDSTONE", RotationHelper.toRotateStr("minecraft:sandstone", 3), "//WOOL", RotationHelper.toRotateStr("minecraft:wool", 16), "//RED_FLOWER", RotationHelper.toRotateStr("minecraft:red_flower", 9), "//Mineral Blocks", "minecraft:iron_block,minecraft:gold_block,minecraft:diamond_block,minecraft:emerald_block", "//DOUBLE_STONE_SLAB", RotationHelper.toRotateStr("minecraft:double_stone_slab", 10), "//STONE_SLAB except meta-2", "minecraft:stone_slab/0,minecraft:stone_slab/1,minecraft:stone_slab/3,minecraft:stone_slab/4,minecraft:stone_slab/5,minecraft:stone_slab/6,minecraft:stone_slab/7", "//OAK_STAIRS series (Wood Stairs)", "minecraft:oak_stairs,minecraft:spruce_stairs,minecraft:birch_stairs,minecraft:jungle_stairs,minecraft:acacia_stairs,minecraft:dark_oak_stairs", "//DOOR series", "minecraft:wooden_door,minecraft:iron_door,minecraft:spruce_door,minecraft:birch_door,minecraft:jungle_door,minecraft:acacia_door,minecraft:dark_oak_door", "//FENCE series", "minecraft:fence,minecraft:spruce_fence,minecraft:birch_fence,minecraft:jungle_fence,minecraft:dark_oak_fence,minecraft:acacia_fence,minecraft:nether_brick_fence", "//STAINED_GLASS", RotationHelper.toRotateStr("minecraft:stained_glass", 16), "//MONSTER_EGG", RotationHelper.toRotateStr("minecraft:monster_egg", 6), "//STONEBRICK", RotationHelper.toRotateStr("minecraft:stonebrick", 4), "//FENCE_GATE series", "minecraft:fence_gate,minecraft:spruce_fence_gate,minecraft:birch_fence_gate,minecraft:jungle_fence_gate,minecraft:dark_oak_fence_gate,minecraft:acacia_fence_gate", "//DOUBLE_WOODEN_SLAB", RotationHelper.toRotateStr("minecraft:double_wooden_slab", 6), "//WOODEN_SLAB", RotationHelper.toRotateStr("minecraft:wooden_slab", 6), "//COBBLESTONE_WALL", RotationHelper.toRotateStr("minecraft:cobblestone_wall", 2), "//QUARTZ_BLOCK", RotationHelper.toRotateStr("minecraft:quartz_block", 3), "//STAINED_HARDENED_CLAY", RotationHelper.toRotateStr("minecraft:stained_hardened_clay", 16), "//STAINED_GLASS_PANE", RotationHelper.toRotateStr("minecraft:stained_glass_pane", 16), "//PRISMARINE", RotationHelper.toRotateStr("minecraft:prismarine", 3), "//CARPET", RotationHelper.toRotateStr("minecraft:carpet", 16), "//DOUBLE_PLANT", RotationHelper.toRotateStr("minecraft:double_plant", 6), "//RED_SANDSTONE", RotationHelper.toRotateStr("minecraft:red_sandstone", 3), "//SHULKER_BOX series", "minecraft:white_shulker_box,minecraft:orange_shulker_box,minecraft:magenta_shulker_box,minecraft:light_blue_shulker_box,minecraft:yellow_shulker_box,minecraft:lime_shulker_box,minecraft:pink_shulker_box,minecraft:gray_shulker_box,minecraft:silver_shulker_box,minecraft:cyan_shulker_box,minecraft:purple_shulker_box,minecraft:blue_shulker_box,minecraft:brown_shulker_box,minecraft:green_shulker_box,minecraft:red_shulker_box,minecraft:black_shulker_box", "//GLAZED_TERRACOTTA series", "minecraft:white_glazed_terracotta,minecraft:orange_glazed_terracotta,minecraft:magenta_glazed_terracotta,minecraft:light_blue_glazed_terracotta,minecraft:yellow_glazed_terracotta,minecraft:lime_glazed_terracotta,minecraft:pink_glazed_terracotta,minecraft:gray_glazed_terracotta,minecraft:silver_glazed_terracotta,minecraft:cyan_glazed_terracotta,minecraft:purple_glazed_terracotta,minecraft:blue_glazed_terracotta,minecraft:brown_glazed_terracotta,minecraft:green_glazed_terracotta,minecraft:red_glazed_terracotta,minecraft:black_glazed_terracotta", "//CONCRETE", RotationHelper.toRotateStr("minecraft:concrete", 16), "//CONCRETE_POWDER", RotationHelper.toRotateStr("minecraft:concrete_powder", 16)};
    public static String[] BLOCK_GROUPS = DEFAULT_BLOCK_GROUPS;

    private static String toRotateStr(String name, int max) {
        StringJoiner joiner = new StringJoiner(",");
        for (int i = 0; i < max; ++i) {
            joiner.add(String.format("%s/%d", name, i));
        }
        return joiner.toString();
    }

    public static boolean canRotate(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_190926_b()) {
            return false;
        }
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        if (block == Blocks.field_150350_a) {
            return false;
        }
        int meta = itemStack.func_77952_i();
        return BLOCK_CHAIN.containsKey(block.func_176203_a(meta));
    }

    private static ItemStack toItemStack(IBlockState state) {
        try {
            ItemStack stack = state.func_177230_c().getPickBlock(state, null, null, null, null);
            if (stack != null && !stack.func_190926_b()) {
                return stack;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_180651_a(state));
    }

    public static List<ItemStack> getAllRotateResult(ItemStack itemStack) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (itemStack == null || itemStack.func_190926_b()) {
            return null;
        }
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        if (block == Blocks.field_150350_a) {
            return null;
        }
        int meta = itemStack.func_77952_i();
        IBlockState srcState = block.func_176203_a(meta);
        if (!BLOCK_CHAIN.containsKey(srcState)) {
            return null;
        }
        stacks.add(itemStack);
        IBlockState state = BLOCK_CHAIN.get(srcState);
        int counter = 0;
        while (state != srcState) {
            stacks.add(RotationHelper.toItemStack(state));
            state = BLOCK_CHAIN.get(state);
            if (++counter < 50000) continue;
            LotTweaks.LOGGER.error("infinite loop!");
            return null;
        }
        return stacks;
    }

    public static boolean loadBlockGroups() {
        BLOCK_CHAIN.clear();
        try {
            int lineCount = 0;
            for (String line : BLOCK_GROUPS) {
                ++lineCount;
                if (line.startsWith("//")) continue;
                ArrayList<IBlockState> states = new ArrayList<IBlockState>();
                for (String part : line.split(",")) {
                    int meta;
                    String blockName;
                    if (part.contains("/")) {
                        String[] name_meta = part.split("/");
                        blockName = name_meta[0];
                        meta = Integer.parseInt(name_meta[1]);
                    } else {
                        blockName = part;
                        meta = 0;
                    }
                    Block block = Block.func_149684_b((String)blockName);
                    if (block == null || block == Blocks.field_150350_a) {
                        LotTweaks.LOGGER.error(String.format("Not found: '%s'", part));
                        LotTweaks.LOGGER.error(String.format("(BLOCK_GROUPS line %d)", lineCount));
                        throw new BlockGroupRegistrationException();
                    }
                    IBlockState state = block.func_176203_a(meta);
                    states.add(state);
                }
                if (states.size() <= 1) {
                    LotTweaks.LOGGER.error("Failed to load group: '%s'", (Object)line);
                    LotTweaks.LOGGER.error(String.format("(BLOCK_GROUPS line %d)", lineCount));
                    throw new BlockGroupRegistrationException();
                }
                for (int i = 0; i < states.size(); ++i) {
                    if (BLOCK_CHAIN.containsKey(states.get(i))) {
                        LotTweaks.LOGGER.error("BLOCK_GROUPS value is invalid.");
                        LotTweaks.LOGGER.error(String.format("(BLOCK_GROUPS line %d)", lineCount));
                        throw new BlockGroupRegistrationException();
                    }
                    BLOCK_CHAIN.put((IBlockState)states.get(i), (IBlockState)states.get((i + 1) % states.size()));
                }
                LotTweaks.LOGGER.debug(String.format("BLOCK_GROUPS line %d: OK", lineCount));
            }
        }
        catch (BlockGroupRegistrationException e) {
            BLOCK_CHAIN.clear();
            return false;
        }
        catch (Exception e) {
            LotTweaks.LOGGER.error((Object)e);
            BLOCK_CHAIN.clear();
            return false;
        }
        return true;
    }

    public static boolean tryToUpdateBlockGroupsFromCommand(String[] newBlockGroups) {
        String[] oldBlockGroups = BLOCK_GROUPS;
        BLOCK_GROUPS = newBlockGroups;
        boolean succeeded = RotationHelper.loadBlockGroups();
        if (succeeded) {
            return true;
        }
        BLOCK_GROUPS = oldBlockGroups;
        return false;
    }

    public static void loadFromFile() {
        File file = new File(new File("config"), BLOCKGROUP_CONFFILE);
        try {
            if (!file.exists()) {
                LotTweaks.LOGGER.debug("Config file does not exist.");
                RotationHelper.writeToFile();
            } else {
                ArrayList<String> list = new ArrayList<String>();
                Scanner scanner = new Scanner(file);
                while (scanner.hasNextLine()) {
                    list.add(scanner.nextLine());
                }
                scanner.close();
                BLOCK_GROUPS = list.toArray(new String[list.size()]);
            }
        }
        catch (IOException e) {
            LotTweaks.LOGGER.error("Failed to load config from file");
            e.printStackTrace();
        }
    }

    public static void writeToFile() {
        LotTweaks.LOGGER.debug("Write config to file.");
        File file = new File(new File("config"), BLOCKGROUP_CONFFILE);
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            for (String line : BLOCK_GROUPS) {
                writer.append(line);
                writer.newLine();
            }
            writer.close();
        }
        catch (IOException e) {
            LotTweaks.LOGGER.error("Failed to write config to file");
            e.printStackTrace();
            return;
        }
        LotTweaks.LOGGER.debug("Finished.");
    }

    private static class BlockGroupRegistrationException
    extends Exception {
        private BlockGroupRegistrationException() {
        }
    }
}

