/*
 * Decompiled with CFR 0.152.
 */
package com.github.lotqwerty.lottweaks.client;

import com.github.lotqwerty.lottweaks.LotTweaks;
import com.github.lotqwerty.lottweaks.RotationHelper;
import java.util.StringJoiner;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.IClientCommand;

public class LotTweaksCommand
extends CommandBase
implements IClientCommand {
    private static final String COMMAND_NAME = "lottweaks";
    private static final String COMMAND_USAGE = String.format("/%s add", "lottweaks");

    public String func_71517_b() {
        return COMMAND_NAME;
    }

    public String func_71518_a(ICommandSender sender) {
        return COMMAND_USAGE;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (args[0].equals("add")) {
            this.executeAdd();
        } else if (args[0].equals("reload")) {
            this.executeReload();
        }
    }

    private void executeAdd() throws CommandException {
        String line;
        Minecraft mc = Minecraft.func_71410_x();
        StringJoiner stringJoiner = new StringJoiner(",");
        int count = 0;
        for (int i = 0; i < InventoryPlayer.func_70451_h(); ++i) {
            ItemStack itemStack = mc.field_71439_g.field_71071_by.func_70301_a(i);
            if (RotationHelper.canRotate(itemStack)) {
                throw new CommandException(String.format("Already exists (%d)", i + 1), new Object[0]);
            }
            System.out.println("Hello");
            if (itemStack.func_190926_b()) break;
            Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
            int meta = itemStack.func_77952_i();
            if (block == Blocks.field_150350_a) {
                throw new CommandException(String.format("Failed to get block instance. (%d)", i + 1), new Object[0]);
            }
            String name = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString();
            if (meta == 0) {
                stringJoiner.add(name);
            } else {
                stringJoiner.add(String.format("%s/%d", name, meta));
            }
            ++count;
        }
        if ((line = stringJoiner.toString()).isEmpty()) {
            throw new CommandException(String.format("Hotbar is empty.", new Object[0]), new Object[0]);
        }
        LotTweaks.LOGGER.debug("adding a new block-group from /lottweaks command");
        LotTweaks.LOGGER.debug(line);
        String[] oldBlockGroups = RotationHelper.BLOCK_GROUPS;
        String[] newBlockGroups = new String[oldBlockGroups.length + 1];
        System.arraycopy(oldBlockGroups, 0, newBlockGroups, 0, oldBlockGroups.length);
        newBlockGroups[newBlockGroups.length - 1] = line;
        boolean succeeded = RotationHelper.tryToUpdateBlockGroupsFromCommand(newBlockGroups);
        if (succeeded) {
            RotationHelper.writeToFile();
            mc.field_71456_v.func_191742_a(ChatType.SYSTEM, (ITextComponent)new TextComponentString(String.format("LotTweaks: added %d blocks", count)));
        } else {
            mc.field_71456_v.func_191742_a(ChatType.SYSTEM, (ITextComponent)new TextComponentString(TextFormatting.RED + "LotTweaks: failed to add blocks"));
        }
    }

    private void executeReload() throws CommandException {
        RotationHelper.loadFromFile();
        RotationHelper.loadBlockGroups();
        Minecraft mc = Minecraft.func_71410_x();
        int groupCount = RotationHelper.BLOCK_CHAIN.size();
        if (groupCount > 0) {
            mc.field_71456_v.func_191742_a(ChatType.SYSTEM, (ITextComponent)new TextComponentString("LotTweaks: reload succeeded!"));
        } else {
            mc.field_71456_v.func_191742_a(ChatType.SYSTEM, (ITextComponent)new TextComponentString(TextFormatting.RED + "LotTweaks: failed to reload config file (0 blocks loaded)"));
        }
    }

    public boolean allowUsageWithoutPrefix(ICommandSender sender, String message) {
        return false;
    }
}

