/*
 * Decompiled with CFR 0.152.
 */
package com.github.lotqwerty.lottweaks.client.keys;

import com.github.lotqwerty.lottweaks.client.keys.AbstractItemSelectKey;
import com.github.lotqwerty.lottweaks.client.renderer.LTRenderer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ExPickKey
extends AbstractItemSelectKey {
    private static final BlockPos[] SEARCH_POS = new BlockPos[]{new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 1, 0), new BlockPos(0, -1, 0), new BlockPos(0, 0, 1), new BlockPos(0, 0, -1), new BlockPos(1, 1, 0), new BlockPos(1, -1, 0), new BlockPos(-1, 1, 0), new BlockPos(-1, -1, 0), new BlockPos(1, 0, 1), new BlockPos(1, 0, -1), new BlockPos(-1, 0, 1), new BlockPos(-1, 0, -1), new BlockPos(0, 1, 1), new BlockPos(0, 1, -1), new BlockPos(0, -1, 1), new BlockPos(0, -1, -1)};

    public ExPickKey(int keyCode, String category) {
        super("Ex Pick", keyCode, category);
    }

    @Override
    protected void onKeyPressStart() {
        super.onKeyPressStart();
        this.candidates.clear();
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.field_71439_g.field_71075_bZ.field_75098_d) {
            RayTraceResult rayTraceResult = mc.field_71476_x;
            if (rayTraceResult != null) {
                ForgeHooks.onPickBlock((RayTraceResult)rayTraceResult, (EntityPlayer)mc.field_71439_g, (World)mc.field_71441_e);
            }
            return;
        }
        RayTraceResult rayTraceResult = mc.func_175606_aa().func_174822_a(255.0, mc.func_184121_ak());
        if (rayTraceResult == null) {
            return;
        }
        boolean succeeded = ForgeHooks.onPickBlock((RayTraceResult)rayTraceResult, (EntityPlayer)mc.field_71439_g, (World)mc.field_71441_e);
        if (!succeeded) {
            return;
        }
        ItemStack itemStack = mc.field_71439_g.field_71071_by.func_70448_g();
        if (itemStack.func_190926_b()) {
            return;
        }
        this.addToCandidates(itemStack);
        BlockPos pos = rayTraceResult.func_178782_a();
        for (BlockPos posDiff : SEARCH_POS) {
            try {
                IBlockState state = mc.field_71441_e.func_180495_p(pos.func_177971_a((Vec3i)posDiff));
                itemStack = state.func_177230_c().getPickBlock(state, rayTraceResult, (World)mc.field_71441_e, pos, (EntityPlayer)mc.field_71439_g);
                if (itemStack.func_190926_b()) continue;
                this.addToCandidates(itemStack);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void onKeyReleased() {
        this.candidates.clear();
    }

    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        if (this.field_151474_i == 0) {
            return;
        }
        if (!Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        int wheel = event.getDwheel();
        if (wheel == 0) {
            return;
        }
        event.setCanceled(true);
        if (this.candidates.isEmpty()) {
            return;
        }
        if (wheel > 0) {
            this.rotateCandidatesForward();
        } else {
            this.rotateCandidatesBackward();
        }
        this.updateCurrentItemStack((ItemStack)this.candidates.getFirst());
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        if (this.field_151474_i == 0) {
            return;
        }
        if (!Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
            return;
        }
        if (this.candidates.isEmpty()) {
            return;
        }
        ScaledResolution sr = event.getResolution();
        int x = sr.func_78326_a() / 2 - 8;
        int y = sr.func_78328_b() / 2 - 8;
        LTRenderer.renderItemStacks(this.candidates, x, y, this.field_151474_i, event.getPartialTicks(), this.lastRotateTime, this.rotateDirection);
    }
}

