/*
 * Decompiled with CFR 0.152.
 */
package com.github.lotqwerty.lottweaks.client.keys;

import com.github.lotqwerty.lottweaks.RotationHelper;
import com.github.lotqwerty.lottweaks.client.keys.AbstractItemSelectKey;
import com.github.lotqwerty.lottweaks.client.renderer.LTRenderer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RotateKey
extends AbstractItemSelectKey {
    public RotateKey(int keyCode, String category) {
        super("Rotate", keyCode, category);
    }

    @Override
    protected void onKeyPressStart() {
        super.onKeyPressStart();
        this.candidates.clear();
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.field_71439_g.field_71075_bZ.field_75098_d) {
            return;
        }
        ItemStack itemStack = mc.field_71439_g.field_71071_by.func_70448_g();
        if (itemStack.func_190926_b()) {
            return;
        }
        List<ItemStack> results = RotationHelper.getAllRotateResult(itemStack);
        if (results == null || results.size() <= 1) {
            return;
        }
        this.candidates.addAll(results);
    }

    @Override
    protected void onKeyReleased() {
        this.candidates.clear();
    }

    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        if (this.field_151474_i == 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.field_71439_g.func_184812_l_()) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        int wheel = event.getDwheel();
        if (wheel == 0) {
            return;
        }
        event.setCanceled(true);
        if (this.candidates.isEmpty()) {
            return;
        }
        if (wheel > 0) {
            this.rotateCandidatesForward();
        } else {
            this.rotateCandidatesBackward();
        }
        this.updateCurrentItemStack((ItemStack)this.candidates.getFirst());
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        if (this.field_151474_i == 0) {
            this.candidates.clear();
            return;
        }
        if (!Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
            return;
        }
        if (this.candidates.isEmpty()) {
            return;
        }
        ScaledResolution sr = event.getResolution();
        int x = sr.func_78326_a() / 2 - 90 + Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70461_c * 20 + 2;
        int y = sr.func_78328_b() - 16 - 3;
        LTRenderer.renderItemStacks(this.candidates, x, y -= 50 + (20 + this.candidates.size()), this.field_151474_i, event.getPartialTicks(), this.lastRotateTime, this.rotateDirection);
    }
}

