/*
 * Decompiled with CFR 0.152.
 */
package com.github.lotqwerty.lottweaks.network;

import com.github.lotqwerty.lottweaks.LotTweaks;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class LTPacketHandler {
    private static final SimpleNetworkWrapper INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel("lottweaks");

    public static void init() {
        int id = 0;
        INSTANCE.registerMessage(ReplaceMessageHandler.class, ReplaceMessage.class, id++, Side.SERVER);
        INSTANCE.registerMessage(AdjustRangeMessageHandler.class, AdjustRangeMessage.class, id++, Side.SERVER);
    }

    public static void sendReplaceMessage(BlockPos pos, Block block, int meta, Block checkBlock) {
        INSTANCE.sendToServer((IMessage)new ReplaceMessage(pos, block, meta, checkBlock));
    }

    public static void sendReachRangeMessage(double dist) {
        INSTANCE.sendToServer((IMessage)new AdjustRangeMessage(dist));
    }

    public static class AdjustRangeMessageHandler
    implements IMessageHandler<AdjustRangeMessage, IMessage> {
        public IMessage onMessage(AdjustRangeMessage message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            double dist = message.dist;
            if (dist < 0.0 || 256.0 < dist) {
                return null;
            }
            player.func_71121_q().func_152344_a(() -> {
                IAttributeInstance instance = player.func_110148_a(EntityPlayer.REACH_DISTANCE);
                for (AttributeModifier modifier : instance.func_111122_c()) {
                    if (!modifier.func_111166_b().equals("lottweaks")) continue;
                    instance.func_111124_b(modifier);
                }
                instance.func_111121_a(new AttributeModifier("lottweaks", dist, 0));
            });
            return null;
        }
    }

    public static class AdjustRangeMessage
    implements IMessage {
        private double dist;

        public AdjustRangeMessage(double dist) {
            this.dist = dist;
        }

        public AdjustRangeMessage() {
        }

        public void toBytes(ByteBuf buf) {
            buf.writeDouble(this.dist);
        }

        public void fromBytes(ByteBuf buf) {
            this.dist = buf.readDouble();
        }
    }

    public static class ReplaceMessageHandler
    implements IMessageHandler<ReplaceMessage, IMessage> {
        public IMessage onMessage(ReplaceMessage message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            BlockPos pos = message.pos;
            Block block = message.block;
            int meta = message.meta;
            Block checkBlock = message.checkBlock;
            if (!player.func_184812_l_()) {
                return null;
            }
            if (player.func_71121_q().field_72995_K) {
                return null;
            }
            if (LotTweaks.CONFIG.REQUIRE_OP_TO_USE_REPLACE && FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH()) == null) {
                return null;
            }
            if (block == Blocks.field_150350_a) {
                return null;
            }
            double dist = Math.sqrt(player.func_174818_b(pos));
            if (dist > LotTweaks.CONFIG.REPLACE_RANGE) {
                return null;
            }
            if (player.func_71121_q().func_180495_p(pos).func_177230_c() != checkBlock) {
                return null;
            }
            player.func_71121_q().func_152344_a(() -> player.func_71121_q().func_180501_a(pos, block.func_176203_a(meta), 2));
            return null;
        }
    }

    public static class ReplaceMessage
    implements IMessage {
        private BlockPos pos;
        private Block block;
        private int meta;
        private Block checkBlock;

        public ReplaceMessage(BlockPos pos, Block block, int meta, Block checkBlock) {
            this.pos = pos;
            this.block = block;
            this.meta = meta;
            this.checkBlock = checkBlock;
        }

        public ReplaceMessage() {
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.pos.func_177958_n());
            buf.writeInt(this.pos.func_177956_o());
            buf.writeInt(this.pos.func_177952_p());
            buf.writeInt(Block.func_149682_b((Block)this.block));
            buf.writeInt(this.meta);
            buf.writeInt(Block.func_149682_b((Block)this.checkBlock));
        }

        public void fromBytes(ByteBuf buf) {
            this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            this.block = Block.func_149729_e((int)buf.readInt());
            this.meta = buf.readInt();
            this.checkBlock = Block.func_149729_e((int)buf.readInt());
        }
    }
}

