/*
 * Decompiled with CFR 0.152.
 */
package com.github.lotqwerty.lottweaks.client;

import com.github.lotqwerty.lottweaks.LotTweaks;
import com.github.lotqwerty.lottweaks.RotationHelper;
import java.util.StringJoiner;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandException;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@OnlyIn(value=Dist.CLIENT)
public class LotTweaksCommand {
    private static final String COMMAND_NAME = "/lottweaks";
    private static final String COMMAND_USAGE = String.format("/%s <arg : 'add' or 'reload'>", "/lottweaks");

    private static void displayMessage(ITextComponent textComponent) {
        Minecraft.func_71410_x().field_71456_v.func_238450_a_(ChatType.SYSTEM, textComponent, null);
    }

    @SubscribeEvent
    public void onClientSendChat(ClientChatEvent event) {
        block6: {
            String msg = event.getMessage();
            if (!msg.startsWith(COMMAND_NAME)) {
                return;
            }
            event.setCanceled(true);
            try {
                String[] part = msg.split(" ");
                if (part.length != 2) {
                    throw new CommandException((ITextComponent)new StringTextComponent(TextFormatting.RED + COMMAND_USAGE));
                }
                if (part[1].equals("add")) {
                    this.executeAdd();
                    break block6;
                }
                if (part[1].equals("reload")) {
                    this.executeReload();
                    break block6;
                }
                throw new CommandException((ITextComponent)new StringTextComponent(TextFormatting.RED + COMMAND_USAGE));
            }
            catch (CommandException e) {
                LotTweaksCommand.displayMessage(e.func_197003_a());
            }
        }
    }

    private void executeAdd() throws CommandException {
        String line;
        Minecraft mc = Minecraft.func_71410_x();
        StringJoiner stringJoiner = new StringJoiner(",");
        int count = 0;
        for (int i = 0; i < PlayerInventory.func_70451_h(); ++i) {
            ItemStack itemStack = mc.field_71439_g.field_71071_by.func_70301_a(i);
            if (RotationHelper.canRotate(itemStack)) {
                throw new CommandException((ITextComponent)new StringTextComponent(String.format("Already exists (%d)", i + 1)));
            }
            if (itemStack.func_190926_b()) break;
            Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
            if (block == Blocks.field_150350_a) {
                throw new CommandException((ITextComponent)new StringTextComponent(String.format("Failed to get block instance. (%d)", i + 1)));
            }
            String name = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block).toString();
            stringJoiner.add(name);
            ++count;
        }
        if ((line = stringJoiner.toString()).isEmpty()) {
            throw new CommandException((ITextComponent)new StringTextComponent(String.format("Hotbar is empty.", new Object[0])));
        }
        LotTweaks.LOGGER.debug("adding a new block-group from /lottweaks command");
        LotTweaks.LOGGER.debug(line);
        String[] oldBlockGroups = RotationHelper.BLOCK_GROUPS;
        String[] newBlockGroups = new String[oldBlockGroups.length + 1];
        System.arraycopy(oldBlockGroups, 0, newBlockGroups, 0, oldBlockGroups.length);
        newBlockGroups[newBlockGroups.length - 1] = line;
        boolean succeeded = RotationHelper.tryToUpdateBlockGroupsFromCommand(newBlockGroups);
        if (succeeded) {
            RotationHelper.writeToFile();
            LotTweaksCommand.displayMessage((ITextComponent)new StringTextComponent(String.format("LotTweaks: added %d blocks", count)));
        } else {
            LotTweaksCommand.displayMessage((ITextComponent)new StringTextComponent(TextFormatting.RED + "LotTweaks: failed to add blocks"));
        }
    }

    private void executeReload() throws CommandException {
        RotationHelper.loadFromFile();
        RotationHelper.loadBlockGroups();
        Minecraft mc = Minecraft.func_71410_x();
        int groupCount = RotationHelper.BLOCK_CHAIN.size();
        if (groupCount > 0) {
            LotTweaksCommand.displayMessage((ITextComponent)new StringTextComponent("LotTweaks: reload succeeded!"));
        } else {
            LotTweaksCommand.displayMessage((ITextComponent)new StringTextComponent(TextFormatting.RED + "LotTweaks: failed to reload config file (0 blocks loaded)"));
        }
    }
}

