/*
 * Decompiled with CFR 0.152.
 */
package com.github.lotqwerty.lottweaks.client.keys;

import com.github.lotqwerty.lottweaks.client.keys.AbstractLTKey;
import java.util.Deque;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;

public abstract class AbstractItemSelectKey
extends AbstractLTKey {
    protected final Deque<ItemStack> candidates = new LinkedList<ItemStack>();
    protected int lastRotateTime = -1;
    protected byte rotateDirection = 0;

    public AbstractItemSelectKey(String description, int keyCode, String category) {
        super(description, keyCode, category);
    }

    protected void addToCandidates(ItemStack itemStack) {
        for (ItemStack c : this.candidates) {
            if (!ItemStack.func_77989_b((ItemStack)c, (ItemStack)itemStack)) continue;
            return;
        }
        this.candidates.add(itemStack);
    }

    protected void rotateCandidatesForward() {
        this.candidates.addFirst(this.candidates.pollLast());
        this.updateLastRotateTime();
        this.rotateDirection = 1;
    }

    protected void rotateCandidatesBackward() {
        this.candidates.addLast(this.candidates.pollFirst());
        this.updateLastRotateTime();
        this.rotateDirection = (byte)-1;
    }

    protected void updateCurrentItemStack(ItemStack itemStack) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71439_g.field_71071_by.func_70299_a(mc.field_71439_g.field_71071_by.field_70461_c, itemStack);
        mc.field_71442_b.func_78761_a(mc.field_71439_g.func_184586_b(Hand.MAIN_HAND), 36 + mc.field_71439_g.field_71071_by.field_70461_c);
    }

    @Override
    protected void onKeyPressStart() {
        this.resetLastRotateTime();
        this.rotateDirection = 0;
    }

    private void resetLastRotateTime() {
        this.lastRotateTime = 0;
    }

    private void updateLastRotateTime() {
        this.lastRotateTime = this.field_151474_i;
    }
}

