/*
 * Decompiled with CFR 0.152.
 */
package com.github.lotqwerty.lottweaks.client.keys;

import com.github.lotqwerty.lottweaks.client.keys.AbstractItemSelectKey;
import com.github.lotqwerty.lottweaks.client.renderer.LTRenderer;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ExPickKey
extends AbstractItemSelectKey {
    private static final BlockPos[] SEARCH_POS = new BlockPos[]{new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 1, 0), new BlockPos(0, -1, 0), new BlockPos(0, 0, 1), new BlockPos(0, 0, -1), new BlockPos(1, 1, 0), new BlockPos(1, -1, 0), new BlockPos(-1, 1, 0), new BlockPos(-1, -1, 0), new BlockPos(1, 0, 1), new BlockPos(1, 0, -1), new BlockPos(-1, 0, 1), new BlockPos(-1, 0, -1), new BlockPos(0, 1, 1), new BlockPos(0, 1, -1), new BlockPos(0, -1, 1), new BlockPos(0, -1, -1)};

    public ExPickKey(int keyCode, String category) {
        super("Ex Pick", keyCode, category);
    }

    @Override
    protected void onKeyPressStart() {
        super.onKeyPressStart();
        this.candidates.clear();
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.field_71439_g.func_184812_l_()) {
            RayTraceResult rayTraceResult = mc.field_71476_x;
            if (rayTraceResult != null) {
                ForgeHooks.onPickBlock((RayTraceResult)rayTraceResult, (PlayerEntity)mc.field_71439_g, (World)mc.field_71441_e);
            }
            return;
        }
        RayTraceResult rayTraceResult = mc.func_175606_aa().func_213324_a(255.0, mc.func_184121_ak(), false);
        if (rayTraceResult == null) {
            return;
        }
        boolean succeeded = ForgeHooks.onPickBlock((RayTraceResult)rayTraceResult, (PlayerEntity)mc.field_71439_g, (World)mc.field_71441_e);
        if (!succeeded) {
            return;
        }
        ItemStack itemStack = mc.field_71439_g.field_71071_by.func_70448_g();
        if (itemStack.func_190926_b()) {
            return;
        }
        this.addToCandidates(itemStack);
        BlockPos pos = ((BlockRayTraceResult)rayTraceResult).func_216350_a();
        for (BlockPos posDiff : SEARCH_POS) {
            try {
                BlockState state = mc.field_71441_e.func_180495_p(pos.func_177971_a((Vector3i)posDiff));
                itemStack = state.func_177230_c().getPickBlock(state, rayTraceResult, (IBlockReader)mc.field_71441_e, pos, (PlayerEntity)mc.field_71439_g);
                if (itemStack.func_190926_b()) continue;
                this.addToCandidates(itemStack);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void onKeyReleased() {
        this.candidates.clear();
    }

    @SubscribeEvent
    public void onMouseWheelEvent(InputEvent.MouseScrollEvent event) {
        if (this.field_151474_i == 0) {
            return;
        }
        if (!Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        double wheel = event.getScrollDelta();
        if (wheel == 0.0) {
            return;
        }
        event.setCanceled(true);
        if (this.candidates.isEmpty()) {
            return;
        }
        if (wheel > 0.0) {
            this.rotateCandidatesForward();
        } else {
            this.rotateCandidatesBackward();
        }
        this.updateCurrentItemStack((ItemStack)this.candidates.getFirst());
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        if (this.field_151474_i == 0) {
            return;
        }
        if (!Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
            return;
        }
        if (this.candidates.isEmpty()) {
            return;
        }
        int x = event.getWindow().func_198107_o() / 2 - 8;
        int y = event.getWindow().func_198087_p() / 2 - 8;
        LTRenderer.renderItemStacks(this.candidates, x, y, this.field_151474_i, event.getPartialTicks(), this.lastRotateTime, this.rotateDirection);
    }
}

