/*
 * Decompiled with CFR 0.152.
 */
package com.github.lotqwerty.lottweaks.client.keys;

import com.github.lotqwerty.lottweaks.RotationHelper;
import com.github.lotqwerty.lottweaks.client.keys.AbstractItemSelectKey;
import com.github.lotqwerty.lottweaks.client.renderer.LTRenderer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class RotateKey
extends AbstractItemSelectKey {
    public RotateKey(int keyCode, String category) {
        super("Rotate", keyCode, category);
    }

    @Override
    protected void onKeyPressStart() {
        super.onKeyPressStart();
        this.candidates.clear();
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.field_71439_g.func_184812_l_()) {
            return;
        }
        ItemStack itemStack = mc.field_71439_g.field_71071_by.func_70448_g();
        if (itemStack.func_190926_b()) {
            return;
        }
        List<ItemStack> results = RotationHelper.getAllRotateResult(itemStack);
        if (results == null || results.size() <= 1) {
            return;
        }
        this.candidates.addAll(results);
    }

    @Override
    protected void onKeyReleased() {
        this.candidates.clear();
    }

    @SubscribeEvent
    public void onMouseEvent(InputEvent.MouseScrollEvent event) {
        if (this.field_151474_i == 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.field_71439_g.func_184812_l_()) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        double wheel = event.getScrollDelta();
        if (wheel == 0.0) {
            return;
        }
        event.setCanceled(true);
        if (this.candidates.isEmpty()) {
            return;
        }
        if (wheel > 0.0) {
            this.rotateCandidatesForward();
        } else {
            this.rotateCandidatesBackward();
        }
        this.updateCurrentItemStack((ItemStack)this.candidates.getFirst());
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        if (this.field_151474_i == 0) {
            this.candidates.clear();
            return;
        }
        if (!Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
            return;
        }
        if (this.candidates.isEmpty()) {
            return;
        }
        int x = event.getWindow().func_198107_o() / 2 - 90 + Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70461_c * 20 + 2;
        int y = event.getWindow().func_198087_p() - 16 - 3;
        LTRenderer.renderItemStacks(this.candidates, x, y -= 50 + (20 + this.candidates.size()), this.field_151474_i, event.getPartialTicks(), this.lastRotateTime, this.rotateDirection);
    }
}

