/*
 * Decompiled with CFR 0.152.
 */
package com.github.lotqwerty.lottweaks.network;

import com.github.lotqwerty.lottweaks.LotTweaks;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class LTPacketHandler {
    private static final String PROTOCOL_VERSION = "3";
    private static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("lottweaks"), () -> "3", "3"::equals, "3"::equals);

    public static void init() {
        int id = 0;
        INSTANCE.messageBuilder(ReplaceMessage.class, id++).encoder(ReplaceMessage::toBytes).decoder(ReplaceMessage::new).consumer(ReplaceMessage::handle).add();
        INSTANCE.messageBuilder(AdjustRangeMessage.class, id++).encoder(AdjustRangeMessage::toBytes).decoder(AdjustRangeMessage::new).consumer(AdjustRangeMessage::handle).add();
    }

    public static void sendReplaceMessage(BlockPos pos, BlockState state, BlockState checkState) {
        INSTANCE.sendToServer((Object)new ReplaceMessage(pos, state, checkState));
    }

    public static void sendReachRangeMessage(double dist) {
        INSTANCE.sendToServer((Object)new AdjustRangeMessage(dist));
    }

    public static class AdjustRangeMessage {
        private double dist;

        public AdjustRangeMessage(double dist) {
            this.dist = dist;
        }

        public AdjustRangeMessage(PacketBuffer buf) {
            this(buf.readDouble());
        }

        public void toBytes(PacketBuffer buf) {
            buf.writeDouble(this.dist);
        }

        public void handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().setPacketHandled(true);
            ServerPlayerEntity player = ctx.get().getSender();
            if (this.dist < 0.0 || 256.0 < this.dist) {
                return;
            }
            ctx.get().enqueueWork(() -> {
                ModifiableAttributeInstance instance = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get());
                for (AttributeModifier modifier : instance.func_225505_c_()) {
                    if (!modifier.func_111166_b().equals("lottweaks")) continue;
                    instance.func_111124_b(modifier);
                }
                instance.func_233769_c_(new AttributeModifier("lottweaks", this.dist, AttributeModifier.Operation.ADDITION));
            });
        }
    }

    public static class ReplaceMessage {
        private final BlockPos pos;
        private final BlockState state;
        private final BlockState checkState;

        public ReplaceMessage(BlockPos pos, BlockState state, BlockState checkState) {
            this.pos = pos;
            this.state = state;
            this.checkState = checkState;
        }

        public ReplaceMessage(PacketBuffer buf) {
            this(buf.func_179259_c(), Block.func_196257_b((int)buf.readInt()), Block.func_196257_b((int)buf.readInt()));
        }

        public void toBytes(PacketBuffer buf) {
            buf.func_179255_a(this.pos);
            buf.writeInt(Block.func_196246_j((BlockState)this.state));
            buf.writeInt(Block.func_196246_j((BlockState)this.checkState));
        }

        public void handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().setPacketHandled(true);
            ServerPlayerEntity player = ctx.get().getSender();
            if (!player.func_184812_l_()) {
                return;
            }
            if (player.func_71121_q().field_72995_K) {
                return;
            }
            if (LotTweaks.CONFIG.REQUIRE_OP_TO_USE_REPLACE && player.func_184102_h().func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH()) == null) {
                return;
            }
            if (this.state.func_177230_c() == Blocks.field_150350_a) {
                return;
            }
            double dist = Math.sqrt(player.func_70092_e((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p()));
            if (dist > LotTweaks.CONFIG.REPLACE_RANGE) {
                return;
            }
            if (player.func_71121_q().func_180495_p(this.pos) != this.checkState) {
                return;
            }
            ctx.get().enqueueWork(() -> player.func_71121_q().func_180501_a(this.pos, this.state, 2));
        }
    }
}

