/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.multiblocks;

import com.mcwroofs.kikoz.objects.multiblocks.LowerRoofParts;
import com.mcwroofs.kikoz.objects.roofs.RoofBase;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class LowerRoof
extends RoofBase
implements IWaterLoggable {
    private static final EnumProperty<LowerRoofParts> PART = EnumProperty.func_177709_a((String)"part", LowerRoofParts.class);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static final Map<Direction, VoxelShape> ROOF_BOTTOM = new HashMap<Direction, VoxelShape>();
    private static final Map<Direction, VoxelShape> ROOF_RIGHT = new HashMap<Direction, VoxelShape>();
    String infoname;
    boolean hasTextInfo = true;

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        LowerRoofParts part = (LowerRoofParts)((Object)state.func_177229_b(PART));
        if (part == LowerRoofParts.BOTTOM) {
            return ROOF_BOTTOM.get(state.func_177229_b((IProperty)FACING));
        }
        if (part == LowerRoofParts.BOTTOM_RIGHT) {
            return ROOF_RIGHT.get(state.func_177229_b((IProperty)FACING));
        }
        return ROOF_BOTTOM.get(state.func_177229_b((IProperty)FACING));
    }

    public void place(World world, BlockPos pos, Direction direction) {
        BlockState state = (BlockState)((BlockState)this.func_176223_P().func_206870_a(PART, (Comparable)((Object)LowerRoofParts.BOTTOM))).func_206870_a((IProperty)FACING, (Comparable)direction);
        world.func_180501_a(pos, state, 3);
        this.place(world, pos, state, direction.func_176734_d());
    }

    @Override
    public ForgeRegistryEntry<Block> variableOpacity() {
        return null;
    }

    public void place(World world, BlockPos pos, BlockState state, Direction direction) {
        BlockPos RoofBottomRightPos = this.getRoofBottomRightPos(pos, direction);
        IFluidState bottomEastFluidState = world.func_204610_c(pos.func_177974_f());
        world.func_180501_a(RoofBottomRightPos, (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)LowerRoofParts.BOTTOM_RIGHT))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(bottomEastFluidState.func_206886_c() == Fluids.field_204546_a)), 3);
    }

    @Override
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Override
    public int getHarvestLevel(BlockState state) {
        return 1;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            this.place(world, pos, state, entity.func_174811_aO());
        }
    }

    public void remove(World world, BlockPos pos, BlockState state) {
        BlockPos RoofPartPos;
        Direction facing = (Direction)state.func_177229_b((IProperty)FACING);
        BlockPos RoofPos = this.getRoofPos(pos, (LowerRoofParts)((Object)state.func_177229_b(PART)), facing);
        BlockState RoofBlockState = world.func_180495_p(RoofPos);
        if (RoofBlockState.func_177230_c() == this && !pos.equals((Object)RoofPos)) {
            this.removePart(world, RoofPos, RoofBlockState);
        }
        if ((RoofBlockState = world.func_180495_p(RoofPartPos = this.getRoofBottomLeftPos(RoofPos, facing))).func_177230_c() == this && !pos.equals((Object)RoofPartPos)) {
            this.removePart(world, RoofPartPos, RoofBlockState);
        }
        if ((RoofBlockState = world.func_180495_p(RoofPartPos = this.getRoofBottomRightPos(RoofPos, facing))).func_177230_c() == this && !pos.equals((Object)RoofPartPos)) {
            this.removePart(world, RoofPartPos, RoofBlockState);
        }
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        this.remove(world, pos, state);
        super.func_176208_a(world, pos, state, player);
    }

    private BlockPos getRoofBottomLeftPos(BlockPos base, Direction facing) {
        switch (facing) {
            case NORTH: {
                return base.func_177976_e();
            }
            case EAST: {
                return base.func_177978_c();
            }
            case SOUTH: {
                return base.func_177974_f();
            }
            case WEST: {
                return base.func_177968_d();
            }
        }
        return base.func_177974_f();
    }

    private BlockPos getRoofBottomRightPos(BlockPos base, Direction facing) {
        switch (facing) {
            case NORTH: {
                return base.func_177974_f();
            }
            case EAST: {
                return base.func_177968_d();
            }
            case SOUTH: {
                return base.func_177976_e();
            }
            case WEST: {
                return base.func_177978_c();
            }
        }
        return base.func_177976_e();
    }

    private BlockPos getRoofPos(BlockPos pos, LowerRoofParts part, Direction facing) {
        if (part == LowerRoofParts.BOTTOM) {
            return pos;
        }
        switch (facing) {
            case NORTH: {
                switch (part) {
                    case BOTTOM_RIGHT: {
                        return pos.func_177974_f();
                    }
                }
                return null;
            }
            case EAST: {
                switch (part) {
                    case BOTTOM_RIGHT: {
                        return pos.func_177968_d();
                    }
                }
                return null;
            }
            case SOUTH: {
                switch (part) {
                    case BOTTOM_RIGHT: {
                        return pos.func_177976_e();
                    }
                }
                return null;
            }
            case WEST: {
                switch (part) {
                    case BOTTOM_RIGHT: {
                        return pos.func_177978_c();
                    }
                }
                return null;
            }
        }
        return null;
    }

    private void removePart(World world, BlockPos pos, BlockState state) {
        IFluidState fluidState = world.func_204610_c(pos);
        if (fluidState.func_206886_c() == Fluids.field_204546_a) {
            world.func_180501_a(pos, fluidState.func_206883_i(), 35);
        } else {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 35);
        }
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        BlockPos pos = context.func_195995_a();
        BlockPos RoofBottomLeftPos = this.getRoofBottomLeftPos(pos, context.func_195992_f().func_176734_d());
        BlockPos RoofBottomRightPos = this.getRoofBottomRightPos(pos, context.func_195992_f().func_176734_d());
        if (pos.func_177956_o() < 255 && RoofBottomLeftPos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(RoofBottomLeftPos).func_196953_a(context) && RoofBottomRightPos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(RoofBottomRightPos).func_196953_a(context)) {
            return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a(PART, (Comparable)((Object)LowerRoofParts.BOTTOM))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206884_a(FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8));
        }
        return null;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{PART, FACING, WATERLOGGED});
    }

    public LowerRoof(Block.Properties props) {
        super(props.func_200944_c());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a(PART, (Comparable)((Object)LowerRoofParts.BOTTOM)));
    }

    static {
        ROOF_BOTTOM.put(Direction.NORTH, Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)15.99, (double)16.0, (double)15.99));
        ROOF_BOTTOM.put(Direction.EAST, Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)15.99, (double)16.0, (double)15.99));
        ROOF_BOTTOM.put(Direction.WEST, Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)15.99, (double)16.0, (double)15.99));
        ROOF_BOTTOM.put(Direction.SOUTH, Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)15.99, (double)16.0, (double)15.99));
        ROOF_RIGHT.put(Direction.NORTH, Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)15.99, (double)8.0, (double)15.99));
        ROOF_RIGHT.put(Direction.EAST, Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)15.99, (double)8.0, (double)15.99));
        ROOF_RIGHT.put(Direction.WEST, Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)15.99, (double)8.0, (double)15.99));
        ROOF_RIGHT.put(Direction.SOUTH, Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)15.99, (double)8.0, (double)15.99));
    }
}

