/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.block;

import it.hurts.metallurgy_reforged.Metallurgy;
import it.hurts.metallurgy_reforged.block.BlockTileEntity;
import it.hurts.metallurgy_reforged.block.ModBlocks;
import it.hurts.metallurgy_reforged.tileentity.TileEntityCrusher;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCrusher
extends BlockTileEntity<TileEntityCrusher> {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool BURNING = PropertyBool.func_177716_a((String)"burning");
    private static boolean keepInventory;

    public BlockCrusher(String name) {
        super(Material.field_151573_f, name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(false)));
    }

    public static void setState(boolean active, World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        keepInventory = true;
        if (active) {
            worldIn.func_180501_a(pos, ModBlocks.crusher.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)).func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(true)), 3);
        } else {
            worldIn.func_180501_a(pos, ModBlocks.crusher.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)).func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(false)), 3);
        }
        keepInventory = false;
        if (tileEntity != null) {
            tileEntity.func_145829_t();
            worldIn.func_175690_a(pos, tileEntity);
        }
    }

    private static EnumFacing getFacing(int meta) {
        switch (meta & 3) {
            case 0: {
                return EnumFacing.NORTH;
            }
            case 1: {
                return EnumFacing.SOUTH;
            }
            case 2: {
                return EnumFacing.WEST;
            }
        }
        return EnumFacing.EAST;
    }

    private static int getMetaForFacing(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return 0;
            }
            case SOUTH: {
                return 1;
            }
            case WEST: {
                return 2;
            }
        }
        return 3;
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)ModBlocks.crusher);
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, @Nonnull RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)ModBlocks.crusher);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof TileEntityCrusher) {
            player.openGui((Object)Metallurgy.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)BURNING)).booleanValue()) {
            return 8;
        }
        if (!((Boolean)state.func_177229_b((IProperty)BURNING)).booleanValue()) {
            return 0;
        }
        return 0;
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity te;
        if (!keepInventory && (te = world.func_175625_s(pos)) instanceof TileEntityCrusher) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((TileEntityCrusher)te));
        }
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Override
    public Class<TileEntityCrusher> getTileEntityClass() {
        return TileEntityCrusher.class;
    }

    @Override
    public TileEntityCrusher createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileEntityCrusher();
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, @Nonnull EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te;
        worldIn.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        if (stack.func_82837_s() && (te = worldIn.func_175625_s(pos)) instanceof TileEntityCrusher) {
            ((TileEntityCrusher)te).setCustomName(stack.func_82833_r());
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Nonnull
    public IBlockState func_185499_a(@Nonnull IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    public IBlockState func_185471_a(@Nonnull IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BURNING, FACING});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)BlockCrusher.getFacing(meta)).func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf((meta & 4) != 0));
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState north = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState south = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState west = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState east = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (face == EnumFacing.NORTH && north.func_185913_b() && !south.func_185913_b()) {
                face = EnumFacing.SOUTH;
            } else if (face == EnumFacing.SOUTH && south.func_185913_b() && !north.func_185913_b()) {
                face = EnumFacing.NORTH;
            } else if (face == EnumFacing.WEST && west.func_185913_b() && !east.func_185913_b()) {
                face = EnumFacing.EAST;
            } else if (face == EnumFacing.EAST && east.func_185913_b() && !west.func_185913_b()) {
                face = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)face), 2);
        }
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= BlockCrusher.getMetaForFacing((EnumFacing)state.func_177229_b((IProperty)FACING));
        if (((Boolean)state.func_177229_b((IProperty)BURNING)).booleanValue()) {
            i |= 4;
        }
        return i;
    }

    @Nonnull
    public BlockCrusher setCreativeTab(@Nonnull CreativeTabs tab) {
        super.func_149647_a(tab);
        return this;
    }
}

