/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.block.gadget;

import it.hurts.metallurgy_reforged.block.BlockOrientable;
import it.hurts.metallurgy_reforged.block.gadget.PhosphorusLampSavedData;
import it.hurts.metallurgy_reforged.config.PhosphorusLampConfig;
import it.hurts.metallurgy_reforged.util.Constants;
import it.hurts.metallurgy_reforged.util.MetallurgyTabs;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPhosphorusLamp
extends BlockOrientable {
    public BlockPhosphorusLamp() {
        super(Material.field_151573_f, "phosphorus_lamp", MetallurgyTabs.tabSpecial);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(4.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
    }

    @Override
    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, EnumHand hand) {
        if (this.canPlaceAt(world, pos, facing)) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        PhosphorusLampSavedData.getInstance(worldIn).addLanternToList(pos);
    }

    public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        PhosphorusLampSavedData.getInstance(worldIn).removeLanternFromList(pos);
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.checkLampFall(worldIn, pos, state);
    }

    private boolean canPlaceAt(World worldIn, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        IBlockState blockstate = worldIn.func_180495_p(blockpos);
        return blockstate.func_185917_h() && !worldIn.func_175623_d(blockpos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkLampFall(worldIn, pos, state);
    }

    private void checkLampFall(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canPlaceAt(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)FACING)) && !worldIn.field_72995_K) {
            EntityFallingBlock fallingLamp = new EntityFallingBlock(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
            fallingLamp.field_145812_b = 1;
            worldIn.func_72838_d((Entity)fallingLamp);
            worldIn.func_175698_g(pos);
        }
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(Constants.PHOSPHORUS_LAMP);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (facing) {
            case NORTH: {
                return new AxisAlignedBB(0.3, 0.09, 0.85, 0.7, 0.6, 0.45);
            }
            case SOUTH: {
                return new AxisAlignedBB(0.3, 0.09, 0.15, 0.7, 0.6, 0.55);
            }
            case WEST: {
                return new AxisAlignedBB(0.85, 0.09, 0.3, 0.45, 0.6, 0.7);
            }
            case EAST: {
                return new AxisAlignedBB(0.15, 0.09, 0.3, 0.55, 0.6, 0.7);
            }
            case UP: {
                return new AxisAlignedBB(0.3, 0.0, 0.3, 0.69, 0.5, 0.69);
            }
            case DOWN: {
                return new AxisAlignedBB(0.3, 0.13, 0.3, 0.69, 0.63, 0.69);
            }
        }
        return super.func_185496_a(state, source, pos);
    }

    public int getLightValue(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return PhosphorusLampConfig.lanternLightLevel;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int i = 0;
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                i |= 1;
                break;
            }
            case WEST: {
                i |= 2;
                break;
            }
            case SOUTH: {
                i |= 3;
                break;
            }
            case NORTH: {
                i |= 4;
                break;
            }
            case DOWN: {
                i |= 5;
                break;
            }
            case UP: {
                i |= 6;
            }
        }
        return i;
    }

    @Override
    @Nonnull
    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        switch (meta) {
            case 1: {
                state = state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST);
                break;
            }
            case 2: {
                state = state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST);
                break;
            }
            case 3: {
                state = state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
                break;
            }
            case 4: {
                state = state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
                break;
            }
            case 5: {
                state = state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN);
                break;
            }
            case 6: {
                state = state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP);
            }
        }
        return state;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        if (PhosphorusLampConfig.enableLanternCollision) {
            return this.func_185496_a(blockState, worldIn, pos);
        }
        return null;
    }
}

