/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.block.gadget;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class PhosphorusLampSavedData
extends WorldSavedData {
    private static final String DATA_NAME = "metallurgy_PhosphorusLampRange";
    private List<BlockPos> lamps = Lists.newArrayList();

    public PhosphorusLampSavedData() {
        super(DATA_NAME);
    }

    public PhosphorusLampSavedData(String dataId) {
        super(dataId);
    }

    public void func_76184_a(@Nonnull NBTTagCompound nbt) {
        int i = 0;
        while (nbt.func_74764_b("lamp_" + i)) {
            this.lamps.add(BlockPos.func_177969_a((long)nbt.func_74763_f("lamp_" + i)));
            ++i;
        }
        this.func_76185_a();
    }

    @Nonnull
    public NBTTagCompound func_189551_b(@Nonnull NBTTagCompound compound) {
        for (int i = 0; i < this.lamps.size(); ++i) {
            compound.func_74772_a("lamp_" + i, this.lamps.get(i).func_177986_g());
        }
        return compound;
    }

    public void addLanternToList(BlockPos lantern) {
        this.lamps.add(lantern);
        this.func_76185_a();
    }

    public void removeLanternFromList(BlockPos lantern) {
        this.lamps.remove(lantern);
        this.func_76185_a();
    }

    public boolean isEntityInRange(BlockPos entityPos, World world) {
        boolean found = false;
        for (int i = 0; !found && i < this.lamps.size(); ++i) {
            BlockPos block = this.lamps.get(i);
            if (!world.func_175667_e(block) || !(block.func_185332_f(entityPos.func_177958_n(), entityPos.func_177956_o(), entityPos.func_177952_p()) <= 8.0)) continue;
            found = true;
        }
        return found;
    }

    public static PhosphorusLampSavedData getInstance(World world) {
        MapStorage storage = world.getPerWorldStorage();
        PhosphorusLampSavedData instance = (PhosphorusLampSavedData)storage.func_75742_a(PhosphorusLampSavedData.class, DATA_NAME);
        if (instance == null) {
            instance = new PhosphorusLampSavedData();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
        }
        return instance;
    }
}

