/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.capabilities.punch;

import it.hurts.metallurgy_reforged.capabilities.punch.IPunchEffect;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class PunchEffect
implements IPunchEffect {
    private int hit_ticks = 0;
    private int knockbackTicks = 0;
    private int delayFromHit = 0;
    private boolean hasNoAI = true;
    private UUID plUUID = null;
    private float rotYaw = 0.0f;
    private float rotPitch = 0.0f;
    private boolean isGauntletUserDead = false;

    @Override
    public void setHitTicks(int ticks) {
        this.hit_ticks = ticks;
    }

    @Override
    public int getHitTicks() {
        return this.hit_ticks;
    }

    @Override
    public void addHitTicks() {
        ++this.hit_ticks;
    }

    @Override
    public void endEffect(EntityLivingBase entity) {
        this.setKnockbackTicks(0);
        this.setHitTicks(0);
        entity.field_70145_X = false;
    }

    @Override
    public void setKnockbackTicks(int ticks) {
        this.knockbackTicks = ticks;
    }

    @Override
    public int getKnockbackTicks() {
        return this.knockbackTicks;
    }

    @Override
    public void addKnockbackTicks() {
        ++this.knockbackTicks;
    }

    @Override
    public void setDelayHit(int delay) {
        this.delayFromHit = delay;
    }

    @Override
    public int getDelayHit() {
        return this.delayFromHit;
    }

    @Override
    public void setPunchingPlayer(EntityPlayer pl) {
        this.plUUID = pl == null ? null : pl.func_110124_au();
    }

    @Override
    @Nullable
    public EntityPlayer getPunchingPlayer(World world) {
        return this.plUUID != null ? world.func_152378_a(this.plUUID) : null;
    }

    @Override
    public Vec3d getKnockbackMotionVec() {
        float yaw = this.getRotYawPlayer();
        float pitch = this.getRotPitchPlayer();
        double x = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        double y = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        double z = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        double f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        double velocity = this.getHitTicks() > 10 ? 2.0 : 1.0;
        x /= f;
        y /= f;
        z /= f;
        return new Vec3d(x *= velocity, y *= velocity, z *= velocity);
    }

    @Override
    public boolean isAIDisabled() {
        return this.hasNoAI;
    }

    @Override
    public void setNoAI(boolean ai) {
        this.hasNoAI = ai;
    }

    @Override
    public void setRotYawPlayer(float yaw) {
        this.rotYaw = yaw;
    }

    @Override
    public void setRotPitchPlayer(float pitch) {
        this.rotPitch = pitch;
    }

    @Override
    public float getRotYawPlayer() {
        return this.rotYaw;
    }

    @Override
    public float getRotPitchPlayer() {
        return this.rotPitch;
    }

    @Override
    public boolean isGauntletUserDead() {
        return this.isGauntletUserDead;
    }

    @Override
    public void setGauntletUserDead() {
        this.isGauntletUserDead = true;
    }
}

