/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect;

import it.hurts.metallurgy_reforged.effect.MetallurgyEffects;
import it.hurts.metallurgy_reforged.item.tool.EnumTools;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.util.Utils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BaseMetallurgyEffect {
    protected Metal metal;

    public BaseMetallurgyEffect(Metal metal) {
        this.metal = metal;
        if (this.isEnabled()) {
            MetallurgyEffects.effects.add(this);
        }
    }

    public boolean isEnabled() {
        return this.metal != null;
    }

    public abstract boolean isToolEffect();

    @Nullable
    public abstract EnumTools getToolClass();

    public String getTooltip() {
        if (this.isToolEffect()) {
            if (this.getToolClass() != null) {
                return Utils.localize("tooltip.metallurgy." + this.metal.toString() + "_" + this.getToolClass().getName() + "_effect");
            }
            return Utils.localize("tooltip.metallurgy." + this.metal.toString() + "_tool_effect");
        }
        return Utils.localize("tooltip.metallurgy." + this.metal.toString() + "_armor_effect");
    }

    public Metal getMetal() {
        return this.metal;
    }

    public void onPlayerTick(EntityPlayer player) {
    }

    @SideOnly(value=Side.CLIENT)
    public void onEntitiesRender(EntityLivingBase entity, RenderLivingBase<EntityLivingBase> renderer, float partialRenderTicks, double x, double y, double z) {
    }

    public void onEntityEnteringChunk(Entity entity) {
    }

    public void onBlockHarvested(BlockEvent.HarvestDropsEvent event) {
    }

    public void playerBreakSpeed(PlayerEvent.BreakSpeed event) {
    }

    public void onPlayerAttack(EntityPlayer attacker, Entity target) {
    }

    public void onPlayerKill(EntityPlayer killer, EntityLivingBase killedEntity) {
    }

    public void onEntityKillDrop(List<EntityItem> drops, EntityPlayer killer) {
    }

    public void onPlayerInteract(PlayerInteractEvent event) {
    }

    public void onPlayerCollision(GetCollisionBoxesEvent event) {
    }

    public void livingEvent(LivingEvent event) {
    }
}

