/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect;

import it.hurts.metallurgy_reforged.config.ArmorEffectsConfig;
import it.hurts.metallurgy_reforged.config.ToolEffectsConfig;
import it.hurts.metallurgy_reforged.effect.ArmorPotionEffect;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.SwordHitChanceEffect;
import it.hurts.metallurgy_reforged.effect.armor.AdamantineArmorEffect;
import it.hurts.metallurgy_reforged.effect.armor.AtlarusArmorEffect;
import it.hurts.metallurgy_reforged.effect.armor.CelenegilArmorEffect;
import it.hurts.metallurgy_reforged.effect.armor.DeepIronArmorEffect;
import it.hurts.metallurgy_reforged.effect.armor.DesichalkosArmorEffect;
import it.hurts.metallurgy_reforged.effect.armor.EtheriumArmorEffect;
import it.hurts.metallurgy_reforged.effect.armor.EximiteArmorEffect;
import it.hurts.metallurgy_reforged.effect.armor.HaderothArmorEffect;
import it.hurts.metallurgy_reforged.effect.armor.KrikArmorEffect;
import it.hurts.metallurgy_reforged.effect.armor.MithrilArmorEffect;
import it.hurts.metallurgy_reforged.effect.armor.OsmiumLutetiumArmorEffect;
import it.hurts.metallurgy_reforged.effect.armor.PlatinumArmorEffect;
import it.hurts.metallurgy_reforged.effect.armor.PrometheumArmorEffect;
import it.hurts.metallurgy_reforged.effect.armor.QuicksilverArmorEffect;
import it.hurts.metallurgy_reforged.effect.armor.ShadowIronArmorEffect;
import it.hurts.metallurgy_reforged.effect.armor.ShadowSteelArmorEffect;
import it.hurts.metallurgy_reforged.effect.armor.VulcaniteArmorEffect;
import it.hurts.metallurgy_reforged.effect.tool.AtlarusAxeEffect;
import it.hurts.metallurgy_reforged.effect.tool.AtlarusHoeEffect;
import it.hurts.metallurgy_reforged.effect.tool.AtlarusSwordEffect;
import it.hurts.metallurgy_reforged.effect.tool.CelenegilOrichalcumSwordEffect;
import it.hurts.metallurgy_reforged.effect.tool.DeepIronPickaxeEffect;
import it.hurts.metallurgy_reforged.effect.tool.DeepIronShadowSteelSwordEffect;
import it.hurts.metallurgy_reforged.effect.tool.DesichalkosSwordEffect;
import it.hurts.metallurgy_reforged.effect.tool.IgnatiusAxeShovelEffect;
import it.hurts.metallurgy_reforged.effect.tool.IgnatiusPickaxeEffect;
import it.hurts.metallurgy_reforged.effect.tool.KalendriteSwordEffect;
import it.hurts.metallurgy_reforged.effect.tool.MidasiumSwordEffect;
import it.hurts.metallurgy_reforged.effect.tool.SanguiniteSwordEffect;
import it.hurts.metallurgy_reforged.effect.tool.ShadowSteelToolEffect;
import it.hurts.metallurgy_reforged.effect.tool.VulcaniteIgnatiusSwordEffect;
import it.hurts.metallurgy_reforged.item.armor.ItemArmorBase;
import it.hurts.metallurgy_reforged.item.tool.EnumTools;
import it.hurts.metallurgy_reforged.item.tool.IToolEffect;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.MetalStats;
import it.hurts.metallurgy_reforged.material.ModMetals;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class MetallurgyEffects {
    public static Set<BaseMetallurgyEffect> effects = new HashSet<BaseMetallurgyEffect>();
    public static final BaseMetallurgyEffect adamantineEffect = new AdamantineArmorEffect();
    public static final BaseMetallurgyEffect amordrineEffect = new ArmorPotionEffect(ModMetals.AMORDRINE, MobEffects.field_76420_g, 1){

        @Override
        public boolean isEnabled() {
            return ArmorEffectsConfig.amordrineArmorEffect && super.isEnabled();
        }
    };
    public static final BaseMetallurgyEffect angmallenEffect = new ArmorPotionEffect(ModMetals.ANGMALLEN, MobEffects.field_188425_z, 0){

        @Override
        public boolean isEnabled() {
            return ArmorEffectsConfig.angmallenArmorEffect && super.isEnabled();
        }
    };
    public static final BaseMetallurgyEffect astralSilverEffect = new ArmorPotionEffect(ModMetals.ASTRAL_SILVER, MobEffects.field_76430_j, 1){

        @Override
        public boolean isEnabled() {
            return ArmorEffectsConfig.astralSilverArmorEffect && super.isEnabled();
        }
    };
    public static final BaseMetallurgyEffect atlarusArmorEffect = new AtlarusArmorEffect();
    public static final BaseMetallurgyEffect atlarusAxeEffect = new AtlarusAxeEffect();
    public static final BaseMetallurgyEffect atlarusHoeEffect = new AtlarusHoeEffect();
    public static final BaseMetallurgyEffect atlarusSwordEffect = new AtlarusSwordEffect();
    public static final BaseMetallurgyEffect carmotEffect = new ArmorPotionEffect(ModMetals.CARMOT, MobEffects.field_76422_e, 0){

        @Override
        public boolean isEnabled() {
            return ArmorEffectsConfig.carmotArmorEffect && super.isEnabled();
        }
    };
    public static final BaseMetallurgyEffect celenegilEffect = new CelenegilArmorEffect();
    public static final BaseMetallurgyEffect celenegilSwordEffect = new CelenegilOrichalcumSwordEffect(ModMetals.CELENEGIL);
    public static final BaseMetallurgyEffect ceruclaseEffect = new SwordHitChanceEffect(ModMetals.CERUCLASE, 75, () -> new PotionEffect(MobEffects.field_76421_d, 80, 2)){

        @Override
        public boolean isEnabled() {
            return ToolEffectsConfig.ceruclaseSwordEffect && super.isEnabled();
        }
    };
    public static final BaseMetallurgyEffect deepIronEffect = new DeepIronArmorEffect();
    public static final BaseMetallurgyEffect deepIronPickaxeEffect = new DeepIronPickaxeEffect();
    public static final BaseMetallurgyEffect deepIronSwordEffect = new DeepIronShadowSteelSwordEffect(ModMetals.DEEP_IRON);
    public static final DesichalkosSwordEffect desichalkosSwordEffect = new DesichalkosSwordEffect();
    public static final DesichalkosArmorEffect desichalkosArmorEffect = new DesichalkosArmorEffect();
    public static EtheriumArmorEffect etheriumArmorEffect = new EtheriumArmorEffect();
    public static final BaseMetallurgyEffect eximiteEffect = new EximiteArmorEffect();
    public static final BaseMetallurgyEffect haderothEffect = new HaderothArmorEffect();
    public static final BaseMetallurgyEffect ignatiusAxeEffect = new IgnatiusAxeShovelEffect(){

        @Override
        public EnumTools getToolClass() {
            return EnumTools.AXE;
        }
    };
    public static final BaseMetallurgyEffect ignatiusShovelEffect = new IgnatiusAxeShovelEffect(){

        @Override
        public EnumTools getToolClass() {
            return EnumTools.SHOVEL;
        }
    };
    public static final BaseMetallurgyEffect ignatiusPickaxeEffect = new IgnatiusPickaxeEffect();
    public static final BaseMetallurgyEffect ignatiusSwordEffect = new VulcaniteIgnatiusSwordEffect(ModMetals.IGNATIUS);
    public static final BaseMetallurgyEffect kalendriteEffect = new ArmorPotionEffect(ModMetals.KALENDRITE, MobEffects.field_76420_g, 0){

        @Override
        public boolean isEnabled() {
            return ArmorEffectsConfig.kaledriteArmorEffect && super.isEnabled();
        }
    };
    public static final BaseMetallurgyEffect kalendriteSwordEffect = new KalendriteSwordEffect();
    public static final BaseMetallurgyEffect krikEffect = new KrikArmorEffect();
    public static final BaseMetallurgyEffect lutetiumEffect = new OsmiumLutetiumArmorEffect(ModMetals.LUTETIUM);
    public static final BaseMetallurgyEffect midasiumSwordEffect = new MidasiumSwordEffect();
    public static final BaseMetallurgyEffect mithrilEffect = new MithrilArmorEffect();
    public static final BaseMetallurgyEffect mithrilSwordEffect = new SwordHitChanceEffect(ModMetals.MITHRIL, 100, () -> new PotionEffect(MobEffects.field_188423_x, 200, 1));
    public static final BaseMetallurgyEffect orichalcumSwordEffect = new CelenegilOrichalcumSwordEffect(ModMetals.ORICHALCUM);
    public static final BaseMetallurgyEffect osmiumEffect = new OsmiumLutetiumArmorEffect(ModMetals.OSMIUM);
    public static final BaseMetallurgyEffect platinumEffect = new PlatinumArmorEffect();
    public static final BaseMetallurgyEffect prometheumEffect = new PrometheumArmorEffect();
    public static final BaseMetallurgyEffect quicksilverEffect = new QuicksilverArmorEffect();
    public static final BaseMetallurgyEffect sanguiniteSwordEffect = new SanguiniteSwordEffect();
    public static final BaseMetallurgyEffect shadowIronEffect = new ShadowIronArmorEffect();
    public static final BaseMetallurgyEffect shadowIronSwordEffect = new SwordHitChanceEffect(ModMetals.SHADOW_IRON, 50, () -> new PotionEffect(MobEffects.field_76440_q, 100)){

        @Override
        public boolean isEnabled() {
            return ToolEffectsConfig.shadowIronSwordEffect && super.isEnabled();
        }
    };
    public static final BaseMetallurgyEffect shadowSteelArmorEffect = new ShadowSteelArmorEffect();
    public static final BaseMetallurgyEffect shadowSteelToolEffect = new ShadowSteelToolEffect();
    public static final BaseMetallurgyEffect shadowSteelSwordEffect = new DeepIronShadowSteelSwordEffect(ModMetals.SHADOW_STEEL);
    public static final BaseMetallurgyEffect tartariteSwordEffect = new SwordHitChanceEffect(ModMetals.TARTARITE, 25, () -> new PotionEffect(MobEffects.field_82731_v, 80, 1)){

        @Override
        public boolean isEnabled() {
            return ToolEffectsConfig.tartariteSwordEffect && super.isEnabled();
        }
    };
    public static final BaseMetallurgyEffect vulcaniteEffect = new VulcaniteArmorEffect();
    public static final BaseMetallurgyEffect vulcaniteSwordEffect = new VulcaniteIgnatiusSwordEffect(ModMetals.VULCANITE);
    public static final BaseMetallurgyEffect vyroxeresSwordEffect = new SwordHitChanceEffect(ModMetals.VYROXERES, 50, () -> new PotionEffect(MobEffects.field_76436_u, 100, 2)){

        @Override
        public boolean isEnabled() {
            return ToolEffectsConfig.vyroxeresSwordEffect && super.isEnabled();
        }
    };

    public static void initTooltips() {
        for (Item item : ForgeRegistries.ITEMS) {
            ItemArmorBase armor;
            IToolEffect tool;
            MetalStats metalStats;
            BaseMetallurgyEffect effect;
            if (item instanceof IToolEffect && (effect = MetallurgyEffects.getToolEffectFromMetalStats(metalStats = (tool = (IToolEffect)item).getMetalStats(), tool.getToolClass())) != null) {
                tool.setEffect(effect);
            }
            if (!(item instanceof ItemArmorBase) || (effect = MetallurgyEffects.getArmorEffectFromMetalStats(metalStats = (armor = (ItemArmorBase)item).getMetalStats())) == null) continue;
            armor.setEffect(effect);
        }
    }

    private static BaseMetallurgyEffect getToolEffectFromMetalStats(MetalStats stats, EnumTools toolClass) {
        for (BaseMetallurgyEffect effect : effects) {
            Metal metal = effect.getMetal();
            if (metal == null || !metal.toString().equals(stats.getName()) || !effect.isToolEffect()) continue;
            if (effect.getToolClass() != null && effect.getToolClass() == toolClass) {
                return effect;
            }
            if (effect.getToolClass() != null) continue;
            return effect;
        }
        return null;
    }

    private static BaseMetallurgyEffect getArmorEffectFromMetalStats(MetalStats stats) {
        for (BaseMetallurgyEffect effect : effects) {
            Metal metal = effect.getMetal();
            if (metal == null || !metal.toString().equals(stats.getName()) || effect.isToolEffect()) continue;
            return effect;
        }
        return null;
    }
}

