/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.armor;

import it.hurts.metallurgy_reforged.capabilities.entity.EntityData;
import it.hurts.metallurgy_reforged.capabilities.entity.EntityDataProvider;
import it.hurts.metallurgy_reforged.config.ArmorEffectsConfig;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.entity.ai.AIEndermanPlayerSteal;
import it.hurts.metallurgy_reforged.item.tool.EnumTools;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.EventUtils;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class DesichalkosArmorEffect
extends BaseMetallurgyEffect {
    public static final IBlockState[] borrowableBlocks = (IBlockState[])Arrays.stream(ArmorEffectsConfig.desichalkosEndermenBlocks).map(regName -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(regName))).filter(Objects::nonNull).map(Block::func_176223_P).toArray(IBlockState[]::new);

    public DesichalkosArmorEffect() {
        super(ModMetals.DESICHALKOS);
    }

    @Override
    public boolean isEnabled() {
        return ArmorEffectsConfig.desichalkosArmorEffect && super.isEnabled();
    }

    @Override
    public boolean isToolEffect() {
        return false;
    }

    @Override
    @Nullable
    public EnumTools getToolClass() {
        return null;
    }

    @Override
    public void onEntityEnteringChunk(Entity entity) {
        if (entity instanceof EntityEnderman) {
            EntityData entityData = (EntityData)entity.getCapability(EntityDataProvider.ENTITY_DATA_CAPABILITY, null);
            if (entityData != null) {
                entityData.initEnderman();
            }
            ((EntityEnderman)entity).field_70714_bg.func_75776_a(12, (EntityAIBase)new AIEndermanPlayerSteal((EntityEnderman)entity));
        }
    }

    @Override
    public void onPlayerInteract(PlayerInteractEvent event) {
        EntityEnderman enderman;
        Entity target;
        EntityPlayer player = event.getEntityPlayer();
        if (event instanceof PlayerInteractEvent.EntityInteract && EventUtils.isEntityWearingArmor((EntityLivingBase)player, this.metal) && (target = ((PlayerInteractEvent.EntityInteract)event).getTarget()) instanceof EntityEnderman && (enderman = (EntityEnderman)target).func_175489_ck() != null && !player.field_70170_p.field_72995_K) {
            ItemStack snatchedBlock = new ItemStack(enderman.func_175489_ck().func_177230_c());
            if (!player.field_71071_by.func_70441_a(snatchedBlock)) {
                player.func_146097_a(snatchedBlock, false, false);
            }
            enderman.func_175490_a(null);
            EntityData data = (EntityData)enderman.getCapability(EntityDataProvider.ENTITY_DATA_CAPABILITY, null);
            if (data != null) {
                data.wasSnatched = true;
            }
            player.field_70170_p.func_184148_a(null, enderman.field_70165_t, enderman.field_70163_u, enderman.field_70161_v, SoundEvents.field_187531_aU, SoundCategory.HOSTILE, 2.0f, 1.3f);
        }
    }
}

