/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.armor;

import it.hurts.metallurgy_reforged.config.ArmorEffectsConfig;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.item.tool.EnumTools;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.EventUtils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;

public class HaderothArmorEffect
extends BaseMetallurgyEffect {
    public HaderothArmorEffect() {
        super(ModMetals.HADEROTH);
    }

    @Override
    public boolean isEnabled() {
        return ArmorEffectsConfig.haderothArmorEffect && super.isEnabled();
    }

    @Override
    public boolean isToolEffect() {
        return false;
    }

    @Override
    @Nullable
    public EnumTools getToolClass() {
        return null;
    }

    @Override
    public void onPlayerCollision(GetCollisionBoxesEvent event) {
        World world = event.getWorld();
        EntityPlayer player = (EntityPlayer)event.getEntity();
        AxisAlignedBB playerBB = event.getAabb();
        if (EventUtils.isEntityWearingArmor((EntityLivingBase)player, this.metal) && world.func_72875_a(playerBB.func_186662_g(0.1), Material.field_151587_i)) {
            int i;
            BlockPos.PooledMutableBlockPos minPos = BlockPos.PooledMutableBlockPos.func_185345_c((double)(playerBB.field_72340_a + 0.001), (double)(playerBB.field_72338_b + 0.001), (double)(playerBB.field_72339_c + 0.001));
            BlockPos.PooledMutableBlockPos maxPos = BlockPos.PooledMutableBlockPos.func_185345_c((double)(playerBB.field_72336_d - 0.001), (double)(playerBB.field_72337_e - 0.001), (double)(playerBB.field_72334_f - 0.001));
            BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
            if (world.func_175707_a((BlockPos)minPos, (BlockPos)maxPos)) {
                for (i = minPos.func_177958_n(); i <= maxPos.func_177958_n(); ++i) {
                    for (int j = minPos.func_177956_o(); j <= maxPos.func_177956_o(); ++j) {
                        for (int k = minPos.func_177952_p(); k <= maxPos.func_177952_p(); ++k) {
                            pos.func_181079_c(i, j, k);
                            IBlockState state = world.func_180495_p((BlockPos)pos);
                            if (state.func_185904_a() != Material.field_151587_i) continue;
                            AxisAlignedBB lavaBox = Block.field_185505_j.func_186670_a((BlockPos)pos);
                            event.getCollisionBoxesList().add(lavaBox);
                        }
                    }
                }
            }
            if (world.field_72995_K) {
                for (i = 0; i < 10; ++i) {
                    double particleZ;
                    double particleX = player.field_70165_t + Math.random() - 0.5;
                    AxisAlignedBB checkBox = new AxisAlignedBB(particleX - 0.05, player.field_70163_u - 0.05, (particleZ = player.field_70161_v + Math.random() - 0.5) - 0.05, particleX + 0.05, player.field_70163_u + 0.05, particleZ + 0.05);
                    if (!world.func_72875_a(checkBox, Material.field_151587_i)) continue;
                    world.func_190523_a(EnumParticleTypes.FLAME.func_179348_c(), particleX, player.field_70163_u, particleZ, 0.0, -Math.random() * 0.3, 0.0, new int[0]);
                }
            }
        }
    }
}

