/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.armor;

import it.hurts.metallurgy_reforged.capabilities.krik.IKrikEffect;
import it.hurts.metallurgy_reforged.capabilities.krik.KrikEffect;
import it.hurts.metallurgy_reforged.capabilities.krik.KrikEffectProvider;
import it.hurts.metallurgy_reforged.config.ArmorEffectsConfig;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.item.tool.EnumTools;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.EventUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class KrikArmorEffect
extends BaseMetallurgyEffect {
    public KrikArmorEffect() {
        super(ModMetals.KRIK);
    }

    @Override
    public boolean isEnabled() {
        return ArmorEffectsConfig.krikArmorEffect && super.isEnabled();
    }

    @Override
    public boolean isToolEffect() {
        return false;
    }

    @Override
    @Nullable
    public EnumTools getToolClass() {
        return null;
    }

    @Override
    public void onPlayerTick(EntityPlayer player) {
        if (EventUtils.isEntityWearingArmor((EntityLivingBase)player, this.metal)) {
            int STEP = 9;
            IKrikEffect capability = (IKrikEffect)player.getCapability(KrikEffectProvider.KRIK_EFFECT_CAPABILITY, null);
            if (capability != null) {
                int maxLevel = KrikEffect.getMaxLevel(player);
                int level = capability.getHeight();
                if (level <= maxLevel) {
                    if (player.field_70163_u < (double)(level * 9)) {
                        player.field_70181_x = 0.4;
                    } else if (Math.round(player.field_70163_u) == (long)(level * 9)) {
                        player.field_70181_x = 0.0;
                    }
                } else {
                    capability.setHeight(maxLevel);
                }
            }
        }
    }

    @Override
    public void livingEvent(LivingEvent livingEvent) {
        EntityPlayer player;
        LivingFallEvent event;
        if (livingEvent instanceof LivingFallEvent && (event = (LivingFallEvent)livingEvent).getEntity() instanceof EntityPlayer && EventUtils.isEntityWearingArmor((EntityLivingBase)(player = (EntityPlayer)event.getEntity()), this.metal)) {
            event.setCanceled(true);
        }
    }
}

