/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.armor;

import it.hurts.metallurgy_reforged.config.ArmorEffectsConfig;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.item.tool.EnumTools;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.EventUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;

public class OsmiumLutetiumArmorEffect
extends BaseMetallurgyEffect {
    public OsmiumLutetiumArmorEffect(Metal metal) {
        super(metal);
    }

    @Override
    public boolean isEnabled() {
        if (!super.isEnabled()) {
            return false;
        }
        if (this.metal == ModMetals.OSMIUM) {
            return ArmorEffectsConfig.osmiumArmorEffect;
        }
        return ArmorEffectsConfig.lutetiumArmorEffect;
    }

    @Override
    public boolean isToolEffect() {
        return false;
    }

    @Override
    @Nullable
    public EnumTools getToolClass() {
        return null;
    }

    @Override
    public void livingEvent(LivingEvent livingEvent) {
        LivingKnockBackEvent event;
        if (livingEvent instanceof LivingKnockBackEvent && (event = (LivingKnockBackEvent)livingEvent).getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            int osmiumMultiplier = 0;
            int lutetiumMultiplier = 0;
            if (ModMetals.OSMIUM != null) {
                osmiumMultiplier = EventUtils.getArmorPiecesCount(player, (Item[])ModMetals.OSMIUM.getArmorSet());
            }
            if (ModMetals.LUTETIUM != null) {
                lutetiumMultiplier = EventUtils.getArmorPiecesCount(player, (Item[])ModMetals.LUTETIUM.getArmorSet());
            }
            float multiplier = (float)((double)(4 - osmiumMultiplier) * 0.17 + (double)(4 - lutetiumMultiplier) * 0.138);
            event.setStrength(event.getOriginalStrength() * multiplier);
        }
    }
}

