/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.armor;

import it.hurts.metallurgy_reforged.config.ArmorEffectsConfig;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.integration.tic.IntegrationTIC;
import it.hurts.metallurgy_reforged.item.tool.EnumTools;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.EventUtils;
import it.hurts.metallurgy_reforged.util.ModChecker;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;

public class QuicksilverArmorEffect
extends BaseMetallurgyEffect {
    public QuicksilverArmorEffect() {
        super(ModMetals.QUICKSILVER);
    }

    @Override
    public boolean isEnabled() {
        return ArmorEffectsConfig.quicksilverArmorEffect && super.isEnabled();
    }

    @Override
    public boolean isToolEffect() {
        return false;
    }

    @Override
    @Nullable
    public EnumTools getToolClass() {
        return null;
    }

    @Override
    public void livingEvent(LivingEvent livingEvent) {
        EntityPlayer player;
        LivingEntityUseItemEvent event;
        if (livingEvent instanceof LivingEntityUseItemEvent && (event = (LivingEntityUseItemEvent)livingEvent).getEntityLiving() instanceof EntityPlayer && EventUtils.isEntityWearingArmor((EntityLivingBase)(player = (EntityPlayer)event.getEntityLiving()), this.metal)) {
            QuicksilverArmorEffect.apply(event);
        }
    }

    private static boolean isItemBlacklisted(Item item) {
        ResourceLocation registryName = item.getRegistryName();
        if (registryName != null) {
            for (String blacklistedName : ArmorEffectsConfig.quickSilverBlacklist) {
                if (!blacklistedName.equals(registryName.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public static void apply(LivingEntityUseItemEvent event) {
        ItemStack stack = event.getItem();
        Item item = stack.func_77973_b();
        if (QuicksilverArmorEffect.isItemBlacklisted(item)) {
            return;
        }
        int duration = event.getDuration();
        if (ModChecker.isTConLoaded && IntegrationTIC.isCrossbow(item)) {
            if (event instanceof LivingEntityUseItemEvent.Tick) {
                event.setDuration(duration - 1);
            }
        } else if (event instanceof LivingEntityUseItemEvent.Start) {
            if (item.func_77661_b(stack) == EnumAction.BOW) {
                event.setDuration(duration - 7);
            } else {
                event.setDuration(Math.round((float)duration / 2.0f));
            }
        }
    }
}

