/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.armor;

import it.hurts.metallurgy_reforged.config.ArmorEffectsConfig;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.item.tool.EnumTools;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.EventUtils;
import it.hurts.metallurgy_reforged.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class ShadowSteelArmorEffect
extends BaseMetallurgyEffect {
    public ShadowSteelArmorEffect() {
        super(ModMetals.SHADOW_STEEL);
    }

    @Override
    public boolean isEnabled() {
        return ArmorEffectsConfig.shadowSteelArmorEffect && super.isEnabled();
    }

    @Override
    public boolean isToolEffect() {
        return false;
    }

    @Override
    @Nullable
    public EnumTools getToolClass() {
        return null;
    }

    @Override
    public void livingEvent(LivingEvent livingEvent) {
        EntityPlayer player;
        LivingHurtEvent event;
        Entity entity;
        if (livingEvent instanceof LivingHurtEvent && (entity = (event = (LivingHurtEvent)livingEvent).getEntity()) instanceof EntityPlayer && EventUtils.isEntityWearingArmor((EntityLivingBase)(player = (EntityPlayer)entity), this.metal)) {
            float amount = event.getAmount();
            amount -= Utils.getLightArmorPercentage(player, 0.75f) * amount;
            event.setAmount(amount);
        }
    }
}

