/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.tool;

import it.hurts.metallurgy_reforged.config.ToolEffectsConfig;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.item.tool.EnumTools;
import it.hurts.metallurgy_reforged.material.ModMetals;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockVine;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import slimeknights.tconstruct.TConstruct;

public class AtlarusAxeEffect
extends BaseMetallurgyEffect {
    public AtlarusAxeEffect() {
        super(ModMetals.ATLARUS);
    }

    @Override
    public boolean isEnabled() {
        return ToolEffectsConfig.atlarusAxeEffect && super.isEnabled();
    }

    @Override
    public boolean isToolEffect() {
        return true;
    }

    @Override
    @Nullable
    public EnumTools getToolClass() {
        return EnumTools.AXE;
    }

    @Override
    public void onPlayerInteract(PlayerInteractEvent event) {
        World world = event.getWorld();
        ItemStack stack = event.getItemStack();
        EntityPlayer player = event.getEntityPlayer();
        if (stack.func_77973_b() == this.metal.getTool(EnumTools.AXE) && event instanceof PlayerInteractEvent.RightClickItem) {
            Vec3d eyePosition = player.func_174824_e(1.0f);
            Vec3d scaledLookVec = player.func_70040_Z().func_186678_a(30.0);
            Vec3d targetPos = new Vec3d(eyePosition.field_72450_a + scaledLookVec.field_72450_a, eyePosition.field_72448_b + scaledLookVec.field_72448_b, eyePosition.field_72449_c + scaledLookVec.field_72449_c);
            RayTraceResult result = world.func_147447_a(eyePosition, targetPos, false, true, true);
            player.func_184609_a(event.getHand());
            if (result != null) {
                targetPos = new Vec3d((Vec3i)result.func_178782_a());
                BlockPos.func_177980_a((BlockPos)result.func_178782_a().func_177982_a(-2, -2, -2), (BlockPos)result.func_178782_a().func_177982_a(2, 2, 2)).forEach(leavesPos -> {
                    IBlockState state = world.func_180495_p(leavesPos);
                    if ((state.func_177230_c() instanceof BlockLeaves || state.func_177230_c() instanceof BlockVine) && !world.field_72995_K) {
                        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
                            int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
                            List drops = ((IShearable)state.func_177230_c()).onSheared(stack, (IBlockAccess)world, leavesPos, fortune);
                            for (ItemStack drop : drops) {
                                float f = 0.7f;
                                double d = (double)(TConstruct.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                                double d1 = (double)(TConstruct.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                                double d2 = (double)(TConstruct.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                                EntityItem entityitem = new EntityItem(player.func_130014_f_(), (double)leavesPos.func_177958_n() + d, (double)leavesPos.func_177956_o() + d1, (double)leavesPos.func_177952_p() + d2, drop);
                                entityitem.func_174869_p();
                                world.func_72838_d((Entity)entityitem);
                            }
                        }
                        stack.func_179548_a(world, world.func_180495_p(leavesPos), leavesPos, player);
                        world.func_175655_b(leavesPos, true);
                        stack.func_77972_a(1, (EntityLivingBase)player);
                    }
                });
            }
            if (world.field_72995_K) {
                Random random = new Random();
                Vec3d particleVec = player.func_70040_Z().func_186678_a(1.3);
                for (int j = 0; j < 170; ++j) {
                    double d6 = (double)j / 169.0;
                    double d3 = eyePosition.field_72450_a + (targetPos.field_72450_a - player.field_70165_t) * d6 + (random.nextDouble() - 0.5) * 2.0;
                    double d4 = eyePosition.field_72448_b + (targetPos.field_72448_b - player.field_70163_u) * d6 + random.nextDouble() * 2.0 - 1.0;
                    double d5 = eyePosition.field_72449_c + (targetPos.field_72449_c - player.field_70161_v) * d6 + (random.nextDouble() - 0.5) * 2.0;
                    player.field_70170_p.func_190523_a(EnumParticleTypes.CLOUD.func_179348_c(), d3, d4, d5, particleVec.field_72450_a, particleVec.field_72448_b, particleVec.field_72449_c, new int[0]);
                }
            } else {
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187606_E, SoundCategory.AMBIENT, 1.0f, 0.9f);
            }
        }
    }
}

