/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.tool;

import it.hurts.metallurgy_reforged.config.ToolEffectsConfig;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.item.tool.EnumTools;
import it.hurts.metallurgy_reforged.material.ModMetals;
import javax.annotation.Nullable;
import net.minecraft.block.BlockBush;
import net.minecraft.block.material.MaterialTransparent;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class AtlarusHoeEffect
extends BaseMetallurgyEffect {
    private static final int MAX_RANGE = 5;

    public AtlarusHoeEffect() {
        super(ModMetals.ATLARUS);
    }

    @Override
    public boolean isEnabled() {
        return ToolEffectsConfig.atlarusHoeEffect && super.isEnabled();
    }

    @Override
    public boolean isToolEffect() {
        return true;
    }

    @Override
    @Nullable
    public EnumTools getToolClass() {
        return EnumTools.HOE;
    }

    @Override
    public void onPlayerTick(EntityPlayer player) {
        NBTTagCompound tag;
        World world = player.field_70170_p;
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() == this.metal.getTool(EnumTools.HOE) && world.func_82737_E() % 4L == 0L && (tag = stack.func_77978_p()) != null && tag.func_74764_b("range")) {
            NBTTagCompound posTag = tag.func_74775_l("startPos");
            BlockPos startPos = new BlockPos(posTag.func_74762_e("posX"), posTag.func_74762_e("posY"), posTag.func_74762_e("posZ"));
            int range = tag.func_74762_e("range");
            int destroyedBlocks = 0;
            for (int x = -range; x <= range; ++x) {
                for (int y = -5; y <= 5; ++y) {
                    for (int z = -range; z <= range; ++z) {
                        if (Math.abs(x) != range && Math.abs(z) != range) continue;
                        BlockPos pos = startPos.func_177982_a(x, y, z);
                        if (!world.field_72995_K) {
                            if (!(world.func_180495_p(pos).func_177230_c() instanceof BlockBush)) continue;
                            world.func_175655_b(pos, true);
                            ++destroyedBlocks;
                            continue;
                        }
                        if (y != this.getParticleY(world, pos.func_177958_n(), startPos.func_177956_o(), pos.func_177952_p())) continue;
                        for (int i = 0; i < 5; ++i) {
                            double particleX = Math.random();
                            double particleZ = Math.random();
                            double motionX = (double)MathHelper.func_76125_a((int)(pos.func_177958_n() - startPos.func_177958_n()), (int)-1, (int)1) * 0.1;
                            double motionZ = (double)MathHelper.func_76125_a((int)(pos.func_177952_p() - startPos.func_177952_p()), (int)-1, (int)1) * 0.1;
                            world.func_175688_a(EnumParticleTypes.CLOUD, (double)pos.func_177958_n() + particleX, (double)pos.func_177956_o(), (double)pos.func_177952_p() + particleZ, motionX, 0.7, motionZ, new int[0]);
                        }
                    }
                }
            }
            if (destroyedBlocks > 0) {
                stack.func_77972_a(Math.round((float)destroyedBlocks * 0.5f), (EntityLivingBase)player);
            }
            world.func_184148_a(null, (double)startPos.func_177958_n(), (double)startPos.func_177956_o(), (double)startPos.func_177952_p(), SoundEvents.field_187606_E, SoundCategory.AMBIENT, 1.4f, 1.0f - (float)range / 5.0f * 0.3f);
            if (range < 5) {
                tag.func_74768_a("range", range + 1);
            } else {
                tag.func_82580_o("range");
                tag.func_82580_o("startPos");
            }
            stack.func_77982_d(tag);
        }
    }

    private int getParticleY(World world, int x, int y, int z) {
        for (int searchY = 0; searchY < 5; ++searchY) {
            if (!(world.func_180495_p(new BlockPos(x, y + searchY, z)).func_185904_a() instanceof MaterialTransparent)) continue;
            return searchY;
        }
        return 0;
    }

    @Override
    public void onPlayerInteract(PlayerInteractEvent event) {
        ItemStack stack;
        World world = event.getWorld();
        if (event instanceof PlayerInteractEvent.RightClickItem && (stack = event.getItemStack()).func_77973_b() == this.metal.getTool(EnumTools.HOE)) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            if (!tag.func_74764_b("range")) {
                tag.func_74768_a("range", 0);
                BlockPos pos = event.getEntityPlayer().func_180425_c();
                NBTTagCompound posTag = new NBTTagCompound();
                posTag.func_74768_a("posX", pos.func_177958_n());
                posTag.func_74768_a("posY", pos.func_177956_o());
                posTag.func_74768_a("posZ", pos.func_177952_p());
                tag.func_74782_a("startPos", (NBTBase)posTag);
                stack.func_77982_d(tag);
                event.getEntityPlayer().func_184609_a(event.getHand());
                event.getEntityPlayer().func_184811_cZ().func_185145_a(this.metal.getTool(EnumTools.HOE), 30);
                event.setCanceled(true);
            }
        }
    }

    @Override
    public void livingEvent(LivingEvent event) {
        LivingEquipmentChangeEvent changeEvent;
        ItemStack to;
        if (event instanceof LivingEquipmentChangeEvent && (to = (changeEvent = (LivingEquipmentChangeEvent)event).getTo()).func_77973_b() == this.metal.getTool(EnumTools.HOE) && changeEvent.getFrom().func_77973_b() != this.metal.getTool(EnumTools.HOE)) {
            NBTTagCompound tag = to.func_77978_p();
            if (tag != null && tag.func_74764_b("range")) {
                tag.func_82580_o("range");
            }
            to.func_77982_d(tag);
        }
    }
}

