/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.tool;

import it.hurts.metallurgy_reforged.config.ToolEffectsConfig;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.item.tool.EnumTools;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.Utils;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class DeepIronShadowSteelSwordEffect
extends BaseMetallurgyEffect {
    private final UUID SHADOW_STEEL_SWORD_MODIFIER_UUID = UUID.fromString("9bfd3581-6559-468f-a5a5-66c46ff7b70c");
    private final UUID DEEP_IRON_SWORD_MODIFIER_UUID = UUID.fromString("8dfd3581-6559-468f-a5a5-66c46ff7b70b");

    public DeepIronShadowSteelSwordEffect(Metal metal) {
        super(metal);
    }

    @Override
    public boolean isEnabled() {
        if (!super.isEnabled()) {
            return false;
        }
        return this.metal == ModMetals.DEEP_IRON ? ToolEffectsConfig.deepIronSwordEffect : ToolEffectsConfig.shadowSteelSwordEffect;
    }

    @Override
    public boolean isToolEffect() {
        return true;
    }

    @Override
    @Nullable
    public EnumTools getToolClass() {
        return EnumTools.SWORD;
    }

    @Override
    public void onPlayerTick(EntityPlayer player) {
        ItemStack stack = player.func_184614_ca();
        IAttributeInstance attackSpeedInstance = player.func_110148_a(SharedMonsterAttributes.field_188790_f);
        Item deepIronSword = null;
        Item shadowSteelSword = null;
        if (ModMetals.DEEP_IRON != null) {
            deepIronSword = ModMetals.DEEP_IRON.getTool(EnumTools.SWORD);
        }
        if (ModMetals.SHADOW_STEEL != null) {
            shadowSteelSword = ModMetals.SHADOW_STEEL.getTool(EnumTools.SWORD);
        }
        if (stack.func_77973_b() == deepIronSword || stack.func_77973_b() == shadowSteelSword) {
            if (this.metal == ModMetals.SHADOW_STEEL) {
                float percentage = Utils.getLightArmorPercentage(player, 50.0f);
                double added_speed = attackSpeedInstance.func_111125_b() * (double)percentage / 100.0;
                AttributeModifier shadow_steel_modifier = new AttributeModifier(this.SHADOW_STEEL_SWORD_MODIFIER_UUID, "Shadow Steel Sword Modifier", added_speed, 0);
                if (attackSpeedInstance.func_111127_a(this.SHADOW_STEEL_SWORD_MODIFIER_UUID) == null) {
                    attackSpeedInstance.func_111121_a(shadow_steel_modifier);
                } else if (attackSpeedInstance.func_111127_a(this.SHADOW_STEEL_SWORD_MODIFIER_UUID) != null && attackSpeedInstance.func_111127_a(this.SHADOW_STEEL_SWORD_MODIFIER_UUID).func_111164_d() != added_speed) {
                    attackSpeedInstance.func_188479_b(this.SHADOW_STEEL_SWORD_MODIFIER_UUID);
                    attackSpeedInstance.func_111121_a(shadow_steel_modifier);
                }
            } else if (attackSpeedInstance.func_111127_a(this.SHADOW_STEEL_SWORD_MODIFIER_UUID) != null) {
                attackSpeedInstance.func_188479_b(this.SHADOW_STEEL_SWORD_MODIFIER_UUID);
            }
            if (this.metal == ModMetals.DEEP_IRON) {
                AttributeModifier deep_iron_trait_modifier = new AttributeModifier(this.DEEP_IRON_SWORD_MODIFIER_UUID, "Deep Iron SwordTrait Modifier", 2.7, 0);
                if (player.func_70090_H() && attackSpeedInstance.func_111127_a(this.DEEP_IRON_SWORD_MODIFIER_UUID) == null) {
                    attackSpeedInstance.func_111121_a(deep_iron_trait_modifier);
                } else if (attackSpeedInstance.func_111127_a(this.DEEP_IRON_SWORD_MODIFIER_UUID) != null && !player.func_70090_H()) {
                    attackSpeedInstance.func_188479_b(this.DEEP_IRON_SWORD_MODIFIER_UUID);
                }
            } else if (attackSpeedInstance.func_111127_a(this.DEEP_IRON_SWORD_MODIFIER_UUID) != null) {
                attackSpeedInstance.func_188479_b(this.DEEP_IRON_SWORD_MODIFIER_UUID);
            }
        }
    }
}

