/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.tool;

import it.hurts.metallurgy_reforged.config.ToolEffectsConfig;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.item.tool.EnumTools;
import it.hurts.metallurgy_reforged.material.ModMetals;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class DesichalkosSwordEffect
extends BaseMetallurgyEffect {
    public DesichalkosSwordEffect() {
        super(ModMetals.DESICHALKOS);
    }

    @Override
    public boolean isEnabled() {
        return ToolEffectsConfig.desichalkosSwordEffect && super.isEnabled();
    }

    @Override
    public boolean isToolEffect() {
        return true;
    }

    @Override
    @Nullable
    public EnumTools getToolClass() {
        return EnumTools.SWORD;
    }

    @Override
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event instanceof PlayerInteractEvent.RightClickItem) {
            EntityPlayer player = event.getEntityPlayer();
            World world = event.getWorld();
            Item sword = player.func_184586_b(event.getHand()).func_77973_b();
            int radius = ToolEffectsConfig.desichalkosSwordBlinkRadius;
            if (sword == this.metal.getTool(EnumTools.SWORD)) {
                Vec3d targetPos;
                Vec3d look = player.func_70040_Z();
                Vec3d scaledLookVec = look.func_186678_a((double)radius);
                Vec3d eyePosition = player.func_174824_e(1.0f);
                RayTraceResult result = world.func_147447_a(eyePosition, targetPos = new Vec3d(eyePosition.field_72450_a + scaledLookVec.field_72450_a, eyePosition.field_72448_b + scaledLookVec.field_72448_b, eyePosition.field_72449_c + scaledLookVec.field_72449_c), false, true, true);
                if (result != null && result.field_72313_a != RayTraceResult.Type.MISS) {
                    BlockPos pos = result.func_178782_a();
                    switch (result.field_178784_b) {
                        case WEST: {
                            this.teleport(player, pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p());
                            break;
                        }
                        case EAST: {
                            this.teleport(player, pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p());
                            break;
                        }
                        case NORTH: {
                            this.teleport(player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1);
                            break;
                        }
                        case SOUTH: {
                            this.teleport(player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1);
                            break;
                        }
                        case UP: {
                            this.teleport(player, pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
                            break;
                        }
                        case DOWN: {
                            this.teleport(player, pos.func_177958_n(), (float)pos.func_177956_o() - player.field_70131_O, pos.func_177952_p());
                            break;
                        }
                    }
                } else {
                    this.teleport(player, targetPos.field_72450_a, player.func_180425_c().func_177956_o(), targetPos.field_72449_c);
                }
                player.func_184609_a(event.getHand());
                world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                player.func_184811_cZ().func_185145_a(sword, 20 * ToolEffectsConfig.desichalkosSwordEffectCooldown);
            }
        }
    }

    private void teleport(EntityPlayer player, double x, double y, double z) {
        Random random = new Random();
        for (int j = 0; j < 128; ++j) {
            double d6 = (double)j / 127.0;
            float f = (random.nextFloat() - 0.5f) * 0.2f;
            float f1 = (random.nextFloat() - 0.5f) * 0.2f;
            float f2 = (random.nextFloat() - 0.5f) * 0.2f;
            double d3 = player.field_70165_t + (x - player.field_70165_t) * d6 + (random.nextDouble() - 0.5) * (double)player.field_70130_N * 2.0;
            double d4 = player.field_70163_u + (y - player.field_70163_u) * d6 + random.nextDouble() * (double)player.field_70131_O;
            double d5 = player.field_70161_v + (z - player.field_70161_v) * d6 + (random.nextDouble() - 0.5) * (double)player.field_70130_N * 2.0;
            player.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, d3, d4, d5, (double)f, (double)f1, (double)f2, new int[0]);
        }
        player.func_70634_a(x, y, z);
    }
}

