/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.tool;

import it.hurts.metallurgy_reforged.config.ToolEffectsConfig;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.item.tool.EnumTools;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.event.world.BlockEvent;

public abstract class IgnatiusAxeShovelEffect
extends BaseMetallurgyEffect {
    public IgnatiusAxeShovelEffect() {
        super(ModMetals.IGNATIUS);
    }

    @Override
    public boolean isEnabled() {
        if (!super.isEnabled()) {
            return false;
        }
        return this.getToolClass() == EnumTools.AXE ? ToolEffectsConfig.ignatiusAxeEffect : ToolEffectsConfig.ignatiusShovelEffect;
    }

    @Override
    public boolean isToolEffect() {
        return true;
    }

    @Override
    @Nullable
    public abstract EnumTools getToolClass();

    @Override
    public void onBlockHarvested(BlockEvent.HarvestDropsEvent event) {
        Item tool = event.getHarvester().func_184614_ca().func_77973_b();
        if (tool.equals(this.metal.getTool(EnumTools.AXE)) || tool.equals(this.metal.getTool(EnumTools.SHOVEL))) {
            this.dropSmeltedItems(event);
        }
    }

    private void dropSmeltedItems(BlockEvent.HarvestDropsEvent event) {
        for (ItemStack drop : event.getDrops()) {
            ItemStack smeltedItem = FurnaceRecipes.func_77602_a().func_151395_a(drop);
            smeltedItem.func_190920_e(drop.func_190916_E());
            if (smeltedItem.func_190926_b()) continue;
            switch (event.getFortuneLevel()) {
                case 0: {
                    if (!Utils.random.nextBoolean()) break;
                    event.getDrops().clear();
                    event.getDrops().add(smeltedItem);
                    break;
                }
                case 1: {
                    if (Utils.random.nextInt(3) <= 0) break;
                    event.getDrops().clear();
                    event.getDrops().add(smeltedItem);
                    break;
                }
                case 2: {
                    if (Utils.random.nextInt(10) <= 0) break;
                    event.getDrops().clear();
                    event.getDrops().add(smeltedItem);
                    break;
                }
                case 3: {
                    event.getDrops().clear();
                    event.getDrops().add(smeltedItem);
                    break;
                }
            }
        }
    }
}

