/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.tool;

import it.hurts.metallurgy_reforged.config.ToolEffectsConfig;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.item.tool.EnumTools;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class ShadowSteelToolEffect
extends BaseMetallurgyEffect {
    public ShadowSteelToolEffect() {
        super(ModMetals.SHADOW_STEEL);
    }

    @Override
    public boolean isEnabled() {
        return ToolEffectsConfig.shadowSteelToolSpeedEffect && super.isEnabled();
    }

    @Override
    public boolean isToolEffect() {
        return true;
    }

    @Override
    @Nullable
    public EnumTools getToolClass() {
        return null;
    }

    @Override
    public void playerBreakSpeed(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.getEntityPlayer();
        if (this.isShadowSteelTool(player.func_184614_ca().func_77973_b())) {
            float percentage = Utils.getLightArmorPercentage(player, 100.0f);
            float speed = event.getNewSpeed() * percentage / 40.0f;
            event.setNewSpeed(event.getOriginalSpeed() + speed);
        }
    }

    private boolean isShadowSteelTool(Item heldItem) {
        return heldItem == this.metal.getTool(EnumTools.AXE) || heldItem == this.metal.getTool(EnumTools.PICKAXE) || heldItem == this.metal.getTool(EnumTools.SHOVEL);
    }
}

