/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.fluid;

import net.minecraft.block.material.Material;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class FluidMolten
extends Fluid {
    protected Fluid fluid = this;
    protected static final Material material = Material.field_151587_i;
    private int mapColor = -1;
    private float overlayAlpha = 0.2f;
    private static final SoundEvent emptySound = SoundEvents.field_187627_L;
    private static final SoundEvent fillSound = SoundEvents.field_187633_N;
    private static final ResourceLocation default_still = new ResourceLocation("metallurgy", "blocks/molten_metal_still");
    private static final ResourceLocation default_flowing = new ResourceLocation("metallurgy", "blocks/molten_metal_flow");

    public FluidMolten(String name, int mapColor, int temperature) {
        super(name, default_still, default_flowing);
        this.setDensity(800);
        this.setGaseous(false);
        this.setLuminosity(9);
        this.setViscosity(4000);
        this.setTemperature(temperature);
        this.setColor(mapColor);
    }

    public int getColor() {
        return this.mapColor;
    }

    public FluidMolten setColor(int mapColor) {
        this.mapColor = mapColor;
        return this;
    }

    public float getAlpha() {
        return this.overlayAlpha;
    }

    public FluidMolten setAlpha(float overlayAlpha) {
        this.overlayAlpha = overlayAlpha;
        return this;
    }

    public SoundEvent getEmptySound() {
        return emptySound;
    }

    public SoundEvent getFillSound() {
        return fillSound;
    }

    public Material getMaterial() {
        return material;
    }

    public boolean doesVaporize(FluidStack fluidStack) {
        if (this.block == null) {
            return false;
        }
        return this.block.func_176223_P().func_185904_a() == this.getMaterial();
    }

    public FluidStack getFluidStack() {
        return new FluidStack((Fluid)this, 1);
    }

    public ItemStack getBucket() {
        return FluidUtil.getFilledBucket((FluidStack)new FluidStack(this.getFluidStack(), 1));
    }
}

