/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.fluid;

import it.hurts.metallurgy_reforged.block.fluid.FluidBlockTar;
import it.hurts.metallurgy_reforged.config.RegistrationConfig;
import it.hurts.metallurgy_reforged.fluid.FluidMolten;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.BlockUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class ModFluids {
    public static List<BlockFluidClassic> fluidBlocks = new ArrayList<BlockFluidClassic>();
    public static final FluidMolten TAR = (FluidMolten)new FluidMolten("molten_tar", -15657959, 1000).setLuminosity(0);
    public static final FluidMolten THERMITE = new FluidMolten("molten_thermite", -3915259, 3200);
    public static FluidBlockTar fluidBlockTar;
    public static BlockFluidClassic fluidBlockThermite;

    public static void registerFluids() {
        ModMetals.metalMap.forEach((s, metal) -> {
            FluidRegistry.registerFluid((Fluid)metal.getMolten());
            FluidRegistry.addBucketForFluid((Fluid)metal.getMolten());
            if (RegistrationConfig.categoryBlocks.enableMetalFluidBlocks) {
                BlockFluidClassic fluidBlock = new BlockFluidClassic((Fluid)metal.getMolten(), Material.field_151587_i);
                metal.getMolten().setBlock((Block)fluidBlock);
                fluidBlock.setRegistryName("metallurgy", "molten_" + metal.toString());
                fluidBlock.func_149663_c("metallurgy.molten_" + metal.toString());
                fluidBlocks.add(fluidBlock);
            }
        });
        FluidRegistry.registerFluid((Fluid)TAR);
        FluidRegistry.registerFluid((Fluid)THERMITE);
        FluidRegistry.addBucketForFluid((Fluid)TAR);
        FluidRegistry.addBucketForFluid((Fluid)THERMITE);
        fluidBlockTar = new FluidBlockTar(TAR, Material.field_151586_h);
        fluidBlockThermite = new BlockFluidClassic((Fluid)THERMITE, Material.field_151587_i);
        BlockUtils.initFluidBlock(fluidBlockThermite, "molten_thermite");
        BlockUtils.initFluidBlock(fluidBlockTar, "molten_tar");
    }
}

