/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.handler;

import com.google.common.base.CaseFormat;
import it.hurts.metallurgy_reforged.block.BlockTypes;
import it.hurts.metallurgy_reforged.block.ModBlocks;
import it.hurts.metallurgy_reforged.config.RegistrationConfig;
import it.hurts.metallurgy_reforged.item.ModItems;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class OreDictHandler {
    public static void init() {
        ModMetals.metalMap.forEach((name, metal) -> {
            if (RegistrationConfig.categoryItems.enableMetalDusts) {
                OreDictionary.registerOre((String)("dust" + CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, metal.toString())), (Item)metal.getDust());
            }
            OreDictionary.registerOre((String)("ingot" + CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, metal.toString())), (Item)metal.getIngot());
            if (RegistrationConfig.categoryItems.enableMetalNuggets) {
                OreDictionary.registerOre((String)("nugget" + CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, metal.toString())), (Item)metal.getNugget());
            }
            if (!metal.isAlloy()) {
                OreDictionary.registerOre((String)("ore" + CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, metal.toString())), (Block)metal.getOre());
            }
            if (RegistrationConfig.categoryBlocks.enableRawMetalBlocks) {
                OreDictionary.registerOre((String)("block" + CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, metal.toString())), (Block)metal.getBlock(BlockTypes.BLOCK));
            }
        });
        OreDictionary.registerOre((String)"slimeball", (Item)ModItems.tar);
        OreDictionary.registerOre((String)"dustGold", (Item)ModItems.dustGold);
        OreDictionary.registerOre((String)"dustIron", (Item)ModItems.dustIron);
        OreDictionary.registerOre((String)"dustBitumen", (Item)ModItems.bitumen);
        OreDictionary.registerOre((String)"globTar", (Item)ModItems.tar);
        OreDictionary.registerOre((String)"dustPotash", (Item)ModItems.potash);
        OreDictionary.registerOre((String)"dustSulfur", (Item)ModItems.sulfur);
        OreDictionary.registerOre((String)"dustThermite", (Item)ModItems.dustThermite);
        OreDictionary.registerOre((String)"dustPhosphorus", (Item)ModItems.phosphorus);
        OreDictionary.registerOre((String)"oreSulfur", (Block)ModBlocks.oreSulfur);
        OreDictionary.registerOre((String)"orePhosphorus", (Block)ModBlocks.orePhosphorite);
        OreDictionary.registerOre((String)"oreTar", (Block)ModBlocks.oreTar);
        OreDictionary.registerOre((String)"orePotash", (Block)ModBlocks.orePotash);
        OreDictionary.registerOre((String)"blockCharcoal", (Block)ModBlocks.blockCharcoal);
        OreDictionary.registerOre((String)"blockBitumen", (Block)ModBlocks.blockBitumen);
        OreDictionary.registerOre((String)"blockSulfur", (Block)ModBlocks.blockSulfur);
    }

    public static void initOreDict(IForgeRegistryEntry.Impl<?> itemOrBlock) {
        String[] words = itemOrBlock.getRegistryName().func_110623_a().split("_");
        String oreName = "ore";
        for (String word : words) {
            if ("ore".equals(word)) continue;
            oreName = oreName.concat(Utils.capitalize(word));
        }
        if (itemOrBlock instanceof Block) {
            OreDictionary.registerOre((String)oreName, (Block)((Block)itemOrBlock));
        } else if (itemOrBlock instanceof Item) {
            OreDictionary.registerOre((String)oreName, (Item)((Item)itemOrBlock));
        }
    }

    public static NonNullList<ItemStack> getOredictedStacksFromMetalAndPrefix(String prefix, Metal metal) {
        String camelMetal = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, metal.toString());
        return OreDictionary.getOres((String)(prefix + camelMetal));
    }
}

