/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.handler;

import it.hurts.metallurgy_reforged.Metallurgy;
import it.hurts.metallurgy_reforged.block.BlockMetal;
import it.hurts.metallurgy_reforged.block.BlockTypes;
import it.hurts.metallurgy_reforged.block.ModBlocks;
import it.hurts.metallurgy_reforged.capabilities.entity.EntityDataProvider;
import it.hurts.metallurgy_reforged.capabilities.krik.KrikEffectProvider;
import it.hurts.metallurgy_reforged.capabilities.punch.PunchEffectProvider;
import it.hurts.metallurgy_reforged.config.RegistrationConfig;
import it.hurts.metallurgy_reforged.fluid.ModFluids;
import it.hurts.metallurgy_reforged.handler.OreDictHandler;
import it.hurts.metallurgy_reforged.item.ModItems;
import it.hurts.metallurgy_reforged.item.armor.ItemArmorBase;
import it.hurts.metallurgy_reforged.item.tool.EnumTools;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.render.BrassKnucklesBakedModel;
import it.hurts.metallurgy_reforged.render.ModRenderers;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class RegistrationHandler {
    public static final ResourceLocation PUNCH_EFFECT_CAP = new ResourceLocation("metallurgy", "punch_effect");
    public static final ResourceLocation KRIK_EFFECT_CAPABILITY = new ResourceLocation("metallurgy", "krik_effect");
    public static final ResourceLocation ENTITY_DATA_CAPABILITY = new ResourceLocation("metallurgy", "entity_data");

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (Block block : ModBlocks.miscBlocks) {
            event.getRegistry().register((IForgeRegistryEntry)ModBlocks.createItemBlock(block));
        }
        ModMetals.metalMap.forEach((s, metal) -> {
            if (metal.getOre() != null) {
                event.getRegistry().register((IForgeRegistryEntry)ModBlocks.createItemBlock(metal.getOre()));
            }
            for (BlockTypes blockTypes : BlockTypes.values()) {
                if (!blockTypes.isEnabled()) continue;
                event.getRegistry().register((IForgeRegistryEntry)ModBlocks.createItemBlock(metal.getBlock(blockTypes)));
            }
            event.getRegistry().register((IForgeRegistryEntry)metal.getIngot());
            if (RegistrationConfig.categoryItems.enableMetalDusts) {
                event.getRegistry().register((IForgeRegistryEntry)metal.getDust());
            }
            if (RegistrationConfig.categoryItems.enableMetalNuggets) {
                event.getRegistry().register((IForgeRegistryEntry)metal.getNugget());
            }
            if (metal.getToolSet() != null) {
                for (EnumTools enumTools : EnumTools.values()) {
                    if (!enumTools.isEnabled()) continue;
                    event.getRegistry().register((IForgeRegistryEntry)metal.getTool(enumTools));
                }
            }
            if (metal.getArmorSet() != null && RegistrationConfig.categoryItems.enableMetalArmorSets) {
                for (ItemArmorBase itemArmorBase : metal.getArmorSet()) {
                    event.getRegistry().register((IForgeRegistryEntry)itemArmorBase);
                }
            }
        });
        ModItems.extraItems.forEach(item -> event.getRegistry().register((IForgeRegistryEntry)item));
        OreDictHandler.init();
        Metallurgy.logger.info("Metallurgy 4: Reforged: OreDictionary has been initialized");
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block block : ModBlocks.miscBlocks) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
        ModMetals.metalMap.forEach((s, metal) -> {
            if (metal.getOre() != null) {
                event.getRegistry().register((IForgeRegistryEntry)metal.getOre());
            }
            for (BlockTypes type : BlockTypes.values()) {
                if (!type.isEnabled()) continue;
                event.getRegistry().register((IForgeRegistryEntry)metal.getBlock(type));
            }
        });
        for (BlockFluidClassic blockFluidClassic : ModFluids.fluidBlocks) {
            event.getRegistry().register((IForgeRegistryEntry)blockFluidClassic);
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModBlocks.miscBlocks.forEach(block -> ItemUtils.registerCustomItemModel(Item.func_150898_a((Block)block), 0));
        ModItems.extraItems.forEach(item -> ItemUtils.registerCustomItemModel(item, 0, item.getModelSubDir()));
        ModMetals.metalMap.forEach((name, metal) -> {
            if (metal.getOre() != null) {
                ItemUtils.registerCustomItemModel(Item.func_150898_a((Block)metal.getOre()), 0);
            }
            for (BlockMetal blockMetal : metal.getBlocks()) {
                ItemUtils.registerCustomItemModel(Item.func_150898_a((Block)blockMetal), 0);
            }
            ItemUtils.registerCustomItemModel(metal.getIngot(), 0, "ingot");
            ItemUtils.registerCustomItemModel(metal.getDust(), 0, "dust");
            ItemUtils.registerCustomItemModel(metal.getNugget(), 0, "nugget");
            if (metal.getToolSet() != null) {
                for (EnumTools enumTools : EnumTools.values()) {
                    ItemUtils.registerCustomItemModel(metal.getTool(enumTools), 0, "tool/" + enumTools.getName());
                }
            }
            if (metal.getArmorSet() != null) {
                for (ItemArmorBase itemArmorBase : metal.getArmorSet()) {
                    ItemUtils.registerCustomItemModel((Item)itemArmorBase, 0, "armor");
                }
            }
        });
        ItemUtils.registerCustomItemModel(Item.func_150898_a((Block)ModBlocks.crusher), 0);
        ItemUtils.registerCustomItemModel(Item.func_150898_a((Block)ModBlocks.alloyer), 0);
        ItemUtils.registerCustomItemModel(Item.func_150898_a((Block)ModBlocks.chamber), 0);
        ModRenderers.registerRenderers();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        ModelResourceLocation location = new ModelResourceLocation(new ResourceLocation("metallurgy", "gadget/brass_knuckles"), "inventory");
        IBakedModel original = (IBakedModel)event.getModelRegistry().func_82594_a((Object)location);
        event.getModelRegistry().func_82595_a((Object)location, (Object)new BrassKnucklesBakedModel(original));
    }

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityLivingBase) {
            event.addCapability(PUNCH_EFFECT_CAP, (ICapabilityProvider)new PunchEffectProvider());
        }
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(KRIK_EFFECT_CAPABILITY, (ICapabilityProvider)new KrikEffectProvider());
        }
        if (event.getObject() instanceof EntityEnderman) {
            event.addCapability(ENTITY_DATA_CAPABILITY, (ICapabilityProvider)new EntityDataProvider());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerTextures(TextureStitchEvent.Pre event) {
        for (int i = 1; i <= 10; ++i) {
            event.getMap().func_174942_a(new ResourceLocation("metallurgy", "particles/ore_particle_" + i));
        }
        event.getMap().func_174942_a(new ResourceLocation("metallurgy", "items/gadgets/brass_knuckles_item"));
    }
}

