/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.integration;

import it.hurts.metallurgy_reforged.block.BlockTypes;
import it.hurts.metallurgy_reforged.item.ModItems;
import it.hurts.metallurgy_reforged.item.tool.EnumTools;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import java.util.HashMap;
import java.util.Map;
import moze_intel.projecte.api.ProjectEAPI;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class IntegrationProjectE {
    public static final Map<String, Long> emcMap = new HashMap<String, Long>();

    public static void init() {
        ProjectEAPI.getEMCProxy().registerCustomEMC((Object)ModItems.dustIron, 256L);
        ProjectEAPI.getEMCProxy().registerCustomEMC((Object)ModItems.dustGold, 2048L);
        ProjectEAPI.getEMCProxy().registerCustomEMC((Object)ModItems.potash, 128L);
        ProjectEAPI.getEMCProxy().registerCustomEMC((Object)ModItems.dustPotash, 256L);
        ProjectEAPI.getEMCProxy().registerCustomEMC((Object)ModItems.phosphorus, 128L);
        ProjectEAPI.getEMCProxy().registerCustomEMC((Object)ModItems.bitumen, 256L);
        ProjectEAPI.getEMCProxy().registerCustomEMC((Object)ModItems.tar, 128L);
        ModMetals.metalMap.forEach((s, metal) -> {
            long baseValue = emcMap.get(metal.toString());
            ProjectEAPI.getEMCProxy().registerCustomEMC((Object)metal.getIngot(), emcMap.get(metal.toString()).longValue());
            ProjectEAPI.getEMCProxy().registerCustomEMC((Object)metal.getDust(), baseValue);
            ProjectEAPI.getEMCProxy().registerCustomEMC((Object)metal.getNugget(), baseValue / 9L);
            ProjectEAPI.getEMCProxy().registerCustomEMC((Object)metal.getBlock(BlockTypes.BLOCK), baseValue * 9L);
            if (metal.hasToolSet()) {
                ProjectEAPI.getEMCProxy().registerCustomEMC((Object)metal.getTool(EnumTools.AXE), baseValue * 3L + IntegrationProjectE.getExistingEMCValue(Items.field_151055_y) * 2L);
                ProjectEAPI.getEMCProxy().registerCustomEMC((Object)metal.getTool(EnumTools.HOE), baseValue * 2L + IntegrationProjectE.getExistingEMCValue(Items.field_151055_y) * 2L);
                ProjectEAPI.getEMCProxy().registerCustomEMC((Object)metal.getTool(EnumTools.PICKAXE), baseValue * 3L + IntegrationProjectE.getExistingEMCValue(Items.field_151055_y) * 2L);
                ProjectEAPI.getEMCProxy().registerCustomEMC((Object)metal.getTool(EnumTools.SHOVEL), baseValue + IntegrationProjectE.getExistingEMCValue(Items.field_151055_y) * 2L);
                ProjectEAPI.getEMCProxy().registerCustomEMC((Object)metal.getTool(EnumTools.SWORD), baseValue * 2L + IntegrationProjectE.getExistingEMCValue(Items.field_151055_y) * 2L);
            }
            if (metal.hasArmorSet()) {
                ProjectEAPI.getEMCProxy().registerCustomEMC((Object)metal.getArmorPiece(EntityEquipmentSlot.HEAD), baseValue * 5L);
                ProjectEAPI.getEMCProxy().registerCustomEMC((Object)metal.getArmorPiece(EntityEquipmentSlot.CHEST), baseValue * 8L);
                ProjectEAPI.getEMCProxy().registerCustomEMC((Object)metal.getArmorPiece(EntityEquipmentSlot.LEGS), baseValue * 7L);
                ProjectEAPI.getEMCProxy().registerCustomEMC((Object)metal.getArmorPiece(EntityEquipmentSlot.FEET), baseValue * 4L);
            }
        });
    }

    private static long getAlloyIngredientsEMC(ItemStack ingot) {
        if (ingot.func_77973_b().equals(Items.field_151042_j)) {
            return 256L;
        }
        if (ingot.func_77973_b().equals(Items.field_151043_k)) {
            return 2048L;
        }
        Metal metal = ItemUtils.getMetalFromItem(ingot.func_77973_b());
        if (metal != null && metal.hasToolSet()) {
            return IntegrationProjectE.getEMCbyHarvestLevel(metal.getToolMaterial().func_77996_d());
        }
        return 0L;
    }

    private static long getEMCbyHarvestLevel(int harvestLevel) {
        if (harvestLevel == 0) {
            harvestLevel = 1;
        }
        return harvestLevel * harvestLevel * 150;
    }

    private static long getExistingEMCValue(IForgeRegistryEntry<?> entry) {
        if (entry instanceof Item) {
            return ProjectEAPI.getEMCProxy().getValue((Item)entry);
        }
        if (entry instanceof Block) {
            return ProjectEAPI.getEMCProxy().getValue((Block)entry);
        }
        return 0L;
    }

    static {
        emcMap.put("adamantine", 8192L);
        emcMap.put("amordrine", 3072L);
        emcMap.put("angmallen", 1152L);
        emcMap.put("alduorite", 1024L);
        emcMap.put("astral_silver", 2048L);
        emcMap.put("atlarus", 8192L);
        emcMap.put("black_steel", 512L);
        emcMap.put("brass", 224L);
        emcMap.put("bronze", 160L);
        emcMap.put("carmot", 2048L);
        emcMap.put("celenegil", 4096L);
        emcMap.put("ceruclase", 1024L);
        emcMap.put("copper", 128L);
        emcMap.put("damascus_steel", 192L);
        emcMap.put("deep_iron", 192L);
        emcMap.put("desichalkos", 6144L);
        emcMap.put("electrum", 1280L);
        emcMap.put("etherium", 5120L);
        emcMap.put("eximite", 8192L);
        emcMap.put("haderoth", 1024L);
        emcMap.put("hepatizon", 384L);
        emcMap.put("ignatius", 256L);
        emcMap.put("infuscolium", 512L);
        emcMap.put("inolashite", 1024L);
        emcMap.put("kalendrite", 2048L);
        emcMap.put("krik", 512L);
        emcMap.put("lemurite", 1024L);
        emcMap.put("lutetium", 512L);
        emcMap.put("manganese", 2048L);
        emcMap.put("meutoite", 4096L);
        emcMap.put("midasium", 1024L);
        emcMap.put("mithril", 2048L);
        emcMap.put("orichalcum", 4096L);
        emcMap.put("osmium", 512L);
        emcMap.put("oureclase", 1024L);
        emcMap.put("platinum", 4096L);
        emcMap.put("prometheum", 256L);
        emcMap.put("quicksilver", 1280L);
        emcMap.put("rubracium", 1024L);
        emcMap.put("sanguinite", 8192L);
        emcMap.put("shadow_iron", 256L);
        emcMap.put("shadow_steel", 512L);
        emcMap.put("silver", 512L);
        emcMap.put("steel", 3200L);
        emcMap.put("tartarite", 16384L);
        emcMap.put("tin", 256L);
        emcMap.put("vulcanite", 4096L);
        emcMap.put("vyroxeres", 2048L);
        emcMap.put("zinc", 512L);
    }
}

