/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.integration.conarm;

import c4.conarm.lib.materials.ArmorMaterials;
import c4.conarm.lib.materials.CoreMaterialStats;
import c4.conarm.lib.materials.PlatesMaterialStats;
import c4.conarm.lib.materials.TrimMaterialStats;
import c4.conarm.lib.tinkering.TinkersArmor;
import c4.conarm.lib.traits.IArmorTrait;
import it.hurts.metallurgy_reforged.material.Metal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class MetallurgyConArmorStats
extends ArmorMaterials {
    public static TrimMaterialStats getTrimStats(Metal metal) {
        float durability = metal.getStats().getArmorStats().getDurability();
        return new TrimMaterialStats(durability / 12.0f);
    }

    public static CoreMaterialStats getCoreStats(Metal metal) {
        float durability = metal.getStats().getArmorStats().getDurability() / 6;
        float defensePoint = MetallurgyConArmorStats.getDefensePoint(metal.getStats().getArmorStats().getDamageReduction());
        return new CoreMaterialStats(durability, defensePoint);
    }

    public static PlatesMaterialStats getPlatesStats(Metal metal) {
        float durability = metal.getStats().getArmorStats().getDurability() / 3;
        float multiplier = 0.094f;
        float modifier = (float)(Math.sqrt(durability) * (double)multiplier);
        float toughness = metal.getStats().getArmorStats().getToughness();
        return new PlatesMaterialStats(modifier > 2.0f ? modifier * 0.5f : modifier, durability, toughness);
    }

    private static int getDefensePoint(int[] defensePoint) {
        int maxDefensePoint = 0;
        for (int value : defensePoint) {
            maxDefensePoint += value;
        }
        return maxDefensePoint;
    }

    public static boolean hasValidArmorTrait(EntityPlayer player, String traitToCheck) {
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            Item item = stack.func_77973_b();
            if (!(item instanceof TinkersArmor) || ToolHelper.isBroken((ItemStack)stack)) continue;
            NBTTagList list = TagUtil.getTraitsTagList((ItemStack)stack);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                IArmorTrait armorTrait;
                ITrait trait = TinkerRegistry.getTrait((String)list.func_150307_f(i));
                if (!(trait instanceof IArmorTrait) || !(armorTrait = (IArmorTrait)trait).getIdentifier().equals(traitToCheck + "_armor")) continue;
                return true;
            }
        }
        return false;
    }
}

