/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import it.hurts.metallurgy_reforged.integration.crafttweaker.IntegrationCT;
import it.hurts.metallurgy_reforged.recipe.AlloyerRecipes;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.metallurgyreforged.Alloyer")
public class CompatAlloyer {
    @ZenMethod
    public static void addRecipe(IIngredient input1, IIngredient input2, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new Add(input1, input2, output));
    }

    @ZenMethod
    public static void addRecipe(IIngredient input1, IIngredient input2, IItemStack output, float xp) {
        CraftTweakerAPI.apply((IAction)new Add(input1, input2, output, xp));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new Remove(output));
    }

    private static class Remove
    implements IAction {
        private final IItemStack output;

        private Remove(IItemStack output) {
            this.output = output;
        }

        public void apply() {
            ItemStack outputStack = IntegrationCT.toStack(this.output);
            AlloyerRecipes.getInstance().removeAlloyRecipe(outputStack);
        }

        public String describe() {
            return "Removing Metallurgy-Reforged Alloyer Recipe for " + this.output.getDisplayName();
        }
    }

    public static class Add
    implements IAction {
        private final IIngredient input1;
        private final IIngredient input2;
        private final IItemStack output;
        private final float xp;

        private Add(IIngredient input1, IIngredient input2, IItemStack output) {
            this(input1, input2, output, 0.0f);
        }

        private Add(IIngredient input1, IIngredient input2, IItemStack output, float xp) {
            this.input1 = input1;
            this.input2 = input2;
            this.output = output;
            this.xp = xp;
        }

        public void apply() {
            ItemStack[] inputStacks1 = IntegrationCT.toStacks(this.input1.getItemArray());
            ItemStack[] inputStacks2 = IntegrationCT.toStacks(this.input2.getItemArray());
            ItemStack outputStack = IntegrationCT.toStack(this.output);
            for (ItemStack key1 : inputStacks1) {
                for (ItemStack key2 : inputStacks2) {
                    AlloyerRecipes.getInstance().addCustomAlloyRecipe(key1, key2, outputStack, this.xp);
                }
            }
        }

        public String describe() {
            return "Adding Metallurgy-Reforged Alloyer Recipe for " + this.output.getDisplayName();
        }
    }
}

