/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.potions.IPotion;
import it.hurts.metallurgy_reforged.integration.crafttweaker.IntegrationCT;
import it.hurts.metallurgy_reforged.recipe.SublimationRecipes;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.metallurgyreforged.SublimationChamber")
public class CompatSublimationChamber {
    @ZenMethod
    public static void addRecipe(IItemStack input, IPotion output, int duration, int amplifier) {
        CraftTweakerAPI.apply((IAction)new Add(input, output, duration, amplifier));
    }

    @ZenMethod
    public static void removeRecipe(IPotion output) {
        CraftTweakerAPI.apply((IAction)new Remove(output));
    }

    public static class Remove
    implements IAction {
        private IPotion output;

        public Remove(IPotion output) {
            this.output = output;
        }

        public void apply() {
            Potion output = IntegrationCT.getInternalPotion(this.output);
            SublimationRecipes.getInstance().removeSublimationRecipe(output);
        }

        public String describe() {
            return "Removing Metallurgy-Reforged Sublimation Recipe for " + this.output.name();
        }
    }

    public static class Add
    implements IAction {
        private IItemStack input;
        private IPotion output;
        private int duration;
        private int amplifier;

        public Add(IItemStack input, IPotion output, int duration, int amplifier) {
            this.input = input;
            this.output = output;
            this.duration = duration;
            this.amplifier = amplifier;
        }

        public void apply() {
            ItemStack input = IntegrationCT.toStack(this.input);
            Potion output = IntegrationCT.getInternalPotion(this.output);
            PotionEffect outputEffect = new PotionEffect(output, this.duration, this.amplifier);
            SublimationRecipes.getInstance().addSublimationRecipe(input, outputEffect);
        }

        public String describe() {
            return "Adding Metallurgy-Reforged Sublimation Recipe for " + this.output.name();
        }
    }
}

