/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.integration.jei;

import com.google.common.collect.Lists;
import it.hurts.metallurgy_reforged.item.ModItems;
import it.hurts.metallurgy_reforged.item.gadget.ItemOreDetector;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.wrapper.ICustomCraftingRecipeWrapper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class OreDetectorWrapper
implements ICustomCraftingRecipeWrapper {
    private final int size;

    public OreDetectorWrapper(int size) {
        this.size = size;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IIngredients ingredients) {
        ArrayList outputs = Lists.newArrayList();
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        for (int i = 1; i <= inputs.size(); ++i) {
            recipeLayout.getItemStacks().set(i, (List)inputs.get(i - 1));
        }
        ItemStack detector = new ItemStack((Item)ModItems.oreDetector);
        if (this.size != 0) {
            for (int i = 0; i < ((List)inputs.get(1)).size(); ++i) {
                ArrayList currentRecipeIngots = Lists.newArrayList();
                for (int j = 1; j <= this.size; ++j) {
                    currentRecipeIngots.add(((List)inputs.get(j)).get(i));
                }
                ItemOreDetector.addIngotsToDetector(detector, currentRecipeIngots);
                outputs.add(detector.func_77946_l());
            }
        } else {
            recipeLayout.getItemStacks().addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
                if (!input) {
                    tooltip.add(Utils.localize("tooltip.metallurgy.clear_detector_warning"));
                }
            });
            outputs.add(new ItemStack((Item)ModItems.oreDetector));
        }
        recipeLayout.getItemStacks().set(0, (List)outputs);
        recipeLayout.setShapeless();
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ArrayList inputs = Lists.newArrayList();
        inputs.add(Collections.singletonList(new ItemStack((Item)ModItems.oreDetector)));
        if (this.size != 0) {
            ArrayList metalCombs = Lists.newArrayList();
            ModMetals.metalMap.forEach((name, metal) -> {
                if (!metal.isAlloy()) {
                    metalCombs.add(new ItemStack((Item)metal.getIngot()));
                }
            });
            for (int i = 0; i < this.size; ++i) {
                Collections.rotate(metalCombs, 1);
                inputs.add(Lists.newArrayList((Iterable)metalCombs));
            }
        }
        ingredients.setInputLists(VanillaTypes.ITEM, (List)inputs);
    }
}

