/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.integration.jei.alloyer;

import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import it.hurts.metallurgy_reforged.model.AlloySample;
import it.hurts.metallurgy_reforged.recipe.AlloyerRecipes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class AlloyerRecipeWrapper
implements IRecipeWrapper {
    private final List<List<ItemStack>> inputs;
    private final ItemStack output;

    public AlloyerRecipeWrapper(List<List<ItemStack>> inputs, ItemStack output) {
        this.inputs = inputs;
        this.output = output;
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
    }

    public static List<AlloyerRecipeWrapper> getRecipeInputs() {
        ArrayList<AlloyerRecipeWrapper> recipes = new ArrayList<AlloyerRecipeWrapper>();
        for (Table.Cell entry : AlloyerRecipes.getInstance().getRecipeTable().cellSet()) {
            List<ItemStack> inputList1 = ((AlloySample)entry.getRowKey()).getOredictedStacks();
            List<ItemStack> inputList2 = ((AlloySample)entry.getColumnKey()).getOredictedStacks();
            ArrayList inputs = Lists.newArrayList((Object[])new List[]{inputList1, inputList2});
            recipes.add(new AlloyerRecipeWrapper(inputs, ((AlloySample)entry.getValue()).getStack()));
        }
        return recipes;
    }

    public boolean handleClick(@Nonnull Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }
}

