/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.integration.jei.chamber;

import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.recipe.SublimationRecipes;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import it.hurts.metallurgy_reforged.util.Utils;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;

public class ChamberRecipeWrapper
implements IRecipeWrapper {
    private ItemStack input;
    private PotionEffect effect;

    public ChamberRecipeWrapper(ItemStack input, PotionEffect effect) {
        this.input = input;
        this.effect = effect;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public static List<ChamberRecipeWrapper> getRecipeInputs() {
        ArrayList<ChamberRecipeWrapper> recipes = new ArrayList<ChamberRecipeWrapper>();
        SublimationRecipes.getInstance().recipesMap().forEach((input, effect) -> recipes.add(new ChamberRecipeWrapper((ItemStack)input, (PotionEffect)effect)));
        return recipes;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, (Object)this.input);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        Metal metal = ItemUtils.getMetalFromItem(this.input.func_77973_b());
        int color = metal != null ? metal.getStats().getColorHex() : 0xFFFFFF;
        GlStateManager.func_179094_E();
        minecraft.func_110434_K().func_110577_a(GuiContainer.field_147001_a);
        Utils.drawTexturedModalRect(106, 27, this.effect.func_188419_a().func_76392_e() % 8 * 18, 198 + this.effect.func_188419_a().func_76392_e() / 8 * 18, 18, 18);
        minecraft.field_71466_p.func_78276_b(this.effect.func_76459_b() / 20 + " " + Utils.localizeIgnoreFormat("gui.jei_compat.sublimation_chamber.seconds") + " | " + Utils.localizeIgnoreFormat(this.effect.func_76453_d()), 5, 5, color);
        GlStateManager.func_179121_F();
    }
}

