/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.integration.jei.crusher;

import it.hurts.metallurgy_reforged.block.ModBlocks;
import it.hurts.metallurgy_reforged.integration.jei.crusher.CrusherRecipeWrapper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class CrusherRecipeCategory
implements IRecipeCategory<CrusherRecipeWrapper> {
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private final IDrawableStatic background;
    private final IDrawableAnimated flame;
    private final IDrawableAnimated bar;

    public CrusherRecipeCategory(IGuiHelper helper) {
        ResourceLocation texture = new ResourceLocation("metallurgy", "textures/gui/crusher.png");
        this.background = helper.createDrawable(texture, 0, 0, 176, 108);
        IDrawableStatic flameDrawable = helper.createDrawable(texture, 176, 61, 17, 17);
        this.flame = helper.createAnimatedDrawable(flameDrawable, 300, IDrawableAnimated.StartDirection.TOP, true);
        IDrawableStatic barDrawable = helper.createDrawable(texture, 176, 0, 7, 33);
        this.bar = helper.createAnimatedDrawable(barDrawable, 140, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    public void drawExtras(Minecraft minecraft) {
        this.flame.draw(minecraft, 128, 61);
        this.bar.draw(minecraft, 93, 65);
    }

    @Nonnull
    public String getUid() {
        return "metallurgy.crusher";
    }

    @Nonnull
    public String getTitle() {
        return new ItemStack((Block)ModBlocks.crusher).func_82833_r();
    }

    @Nonnull
    public String getModName() {
        return "Metallurgy 4: Reforged";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull CrusherRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup group = recipeLayout.getItemStacks();
        group.init(0, true, 60, 27);
        group.init(1, false, 66, 66);
        group.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        group.set(1, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }
}

