/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.integration.tic.material;

import it.hurts.metallurgy_reforged.integration.tic.material.TinkerMetals;
import it.hurts.metallurgy_reforged.material.Metal;
import slimeknights.tconstruct.library.materials.AbstractMaterialStats;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;

public class MetallurgyTiCStats {
    public final Metal metal;
    public final AbstractMaterialStats[] stats;

    public MetallurgyTiCStats(Metal metal, AbstractMaterialStats ... abstractMaterialStats) {
        this.metal = metal;
        this.stats = abstractMaterialStats;
        if (metal != null) {
            TinkerMetals.metalStatsList.add(this);
        }
    }

    public static HeadMaterialStats getHeadA(Metal metal) {
        int durability = metal.getToolMaterial().func_77997_a();
        float speed = metal.getToolMaterial().func_77998_b();
        float attack = metal.getToolMaterial().func_78000_c();
        int harvestL = metal.getToolMaterial().func_77996_d();
        return new HeadMaterialStats(durability / 4, speed, attack, harvestL);
    }

    public static ExtraMaterialStats getExtraA(Metal metal) {
        int durability = metal.getToolMaterial().func_77997_a();
        return new ExtraMaterialStats((int)((double)durability / 5.5));
    }

    public static HandleMaterialStats getHandleA(Metal metal) {
        int durability = metal.getToolMaterial().func_77997_a();
        float multiplier = 0.07f;
        float modifier = (float)(Math.sqrt(durability) * (double)multiplier);
        return new HandleMaterialStats(modifier > 2.0f ? modifier * 0.5f : modifier, durability / 4);
    }

    public static BowMaterialStats getBowA(Metal metal) {
        int MAX_SPEED = 27;
        float drawspeed = (float)((double)(27.0f - metal.getToolMaterial().func_77998_b()) / 12.3);
        float range = metal.getToolMaterial().func_77998_b() / 12.0f;
        float bonusdamage = metal.getToolMaterial().func_78000_c() / 12.0f;
        return new BowMaterialStats(drawspeed, range, bonusdamage);
    }
}

