/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.integration.tic.material;

import com.google.common.base.CaseFormat;
import it.hurts.metallurgy_reforged.integration.tic.material.TiCMaterials;
import it.hurts.metallurgy_reforged.material.Metal;
import slimeknights.tconstruct.library.materials.Material;

public class TiCMaterial
extends Material {
    private final Metal metal;

    public TiCMaterial(Metal metal) {
        super(metal.toString(), metal.getMolten().getColor(), false);
        this.metal = metal;
        this.setFluid(metal.getMolten());
        this.setCastable(true);
        this.addCommonItems(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, metal.toString()));
        this.setRepresentativeItem("ingot" + CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, metal.toString()));
        TiCMaterials.addMaterialStats(metal, this);
    }

    public String getLocalizedName() {
        String name = this.metal.getStats().getName();
        String[] str = name.split("_");
        String[] space = this.space(str.length);
        name = "";
        for (int i = 0; i < str.length; ++i) {
            name = name + str[i].substring(0, 1).toUpperCase() + str[i].substring(1) + space[i];
        }
        return name;
    }

    private String[] space(int len) {
        String[] str = new String[len];
        for (int i = 0; i < len; ++i) {
            str[i] = i < len - 1 ? " " : "";
        }
        return str;
    }
}

