/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.integration.tic.trait;

import it.hurts.metallurgy_reforged.integration.tic.trait.IMetallurgyTrait;
import it.hurts.metallurgy_reforged.util.Utils;
import java.util.ListIterator;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.modifiers.IToolMod;
import slimeknights.tconstruct.library.traits.AbstractTraitLeveled;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerTraits;

public class MetallurgyTraitVulcan
extends AbstractTraitLeveled
implements IMetallurgyTrait {
    private int levels;

    public MetallurgyTraitVulcan(int levels) {
        super("vulcan_trait", String.valueOf(levels), 0xFFFFFF, 2, levels);
        this.levels = levels;
    }

    public void afterHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damageDealt, boolean wasCritical, boolean wasHit) {
        switch (this.levels) {
            case 0: {
                target.func_70015_d(3);
                break;
            }
            case 1: {
                target.func_70015_d(5);
                break;
            }
            case 2: {
                target.func_70015_d(7);
                break;
            }
            default: {
                target.func_70015_d(3);
            }
        }
    }

    public boolean canApplyTogether(Enchantment enchantment) {
        return enchantment != Enchantments.field_185306_r;
    }

    public boolean canApplyTogether(IToolMod toolmod) {
        return !toolmod.getIdentifier().equals(TinkerTraits.squeaky.getIdentifier()) && !toolmod.getIdentifier().equals(TinkerModifiers.modSilktouch.getIdentifier());
    }

    public void blockHarvestDrops(ItemStack tool, BlockEvent.HarvestDropsEvent event) {
        if (ToolHelper.isToolEffective2((ItemStack)tool, (IBlockState)event.getState())) {
            ListIterator<ItemStack> iter = event.getDrops().listIterator();
            while (iter.hasNext()) {
                ItemStack drop = (ItemStack)iter.next();
                ItemStack smelted = FurnaceRecipes.func_77602_a().func_151395_a(drop);
                if (smelted.func_190926_b()) continue;
                smelted = smelted.func_77946_l();
                smelted.func_190920_e(drop.func_190916_E());
                int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)tool);
                if (Config.autosmeltlapis && fortune > 0) {
                    smelted.func_190920_e(smelted.func_190916_E() * random.nextInt(fortune + 1) + 1);
                }
                iter.set(smelted);
                float xp = FurnaceRecipes.func_77602_a().func_151398_b(smelted);
                if (xp < 1.0f && Math.random() < (double)xp) {
                    xp += 1.0f;
                }
                if (!(xp >= 1.0f)) continue;
                event.getState().func_177230_c().func_180637_b(event.getWorld(), event.getPos(), (int)xp);
            }
        }
    }

    public void afterBlockBreak(ItemStack tool, World world, IBlockState state, BlockPos pos, EntityLivingBase player, boolean wasEffective) {
        if (world.field_72995_K && wasEffective) {
            for (int i = 0; i < 3; ++i) {
                world.func_175688_a(EnumParticleTypes.FLAME, (double)pos.func_177958_n() + random.nextDouble(), (double)pos.func_177956_o() + random.nextDouble(), (double)pos.func_177952_p() + random.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    public void register(String name, @Nullable String tooltip) {
        Utils.localize(String.format("modifier.%s.name", name));
        if (tooltip != null) {
            Utils.localize(String.format("modifier.%s.name", tooltip));
        }
    }
}

