/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.item.armor;

import com.google.common.collect.Multimap;
import it.hurts.metallurgy_reforged.config.GeneralConfig;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.MetalStats;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.Constants;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import it.hurts.metallurgy_reforged.util.MetallurgyTabs;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemArmorBase
extends ItemArmor {
    private BaseMetallurgyEffect effect;
    private Enchantment enchantment;
    private int enchantmentLevel;
    private MetalStats metalStats;

    public ItemArmorBase(ItemArmor.ArmorMaterial material, EntityEquipmentSlot slot, MetalStats metalStats) {
        super(material, 0, slot);
        ItemUtils.initItem((Item)this, metalStats.getName() + '_' + this.getSlotArmorSuffix(slot), MetallurgyTabs.tabArmor);
        this.metalStats = metalStats;
    }

    public void setEffect(BaseMetallurgyEffect effect) {
        this.effect = effect;
    }

    public void setEnchanted(Enchantment enchantment, int enchantmentLevel) {
        this.enchantment = enchantment;
        this.enchantmentLevel = enchantmentLevel;
    }

    public MetalStats getMetalStats() {
        return this.metalStats;
    }

    private ItemStack getRepairStack() {
        String material = this.metalStats.getName().toLowerCase();
        Metal metal = ModMetals.metalMap.get(material);
        if (metal != null) {
            return new ItemStack((Item)metal.getIngot());
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_82789_a(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        return GeneralConfig.enableAnvilArmorRepair && ItemUtils.equalsWildcard(this.getRepairStack(), repair) || super.func_82789_a(toRepair, repair);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        if (this.effect != null && this.effect.isEnabled()) {
            tooltip.add(this.effect.getTooltip());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack enchantedArmor = new ItemStack((Item)this);
            if (this.enchantment != null) {
                enchantedArmor.func_77966_a(this.enchantment, this.enchantmentLevel);
            }
            items.add((Object)enchantedArmor);
        }
    }

    @Nonnull
    public Multimap<String, AttributeModifier> func_111205_h(@Nonnull EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == this.field_77881_a) {
            multimap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(Constants.ModAttributes.ARMOR_MAX_HEALTH.get(equipmentSlot), "Metallurgy Armor Max Health", this.metalStats.getArmorStats().getMaxHealth() / 4.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(Constants.ModAttributes.ARMOR_KNOCKBACK_RESISTANCE.get(equipmentSlot), "Metallurgy Armor Knockback Resistance", this.metalStats.getArmorStats().getKnockbackResistance() / 4.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(Constants.ModAttributes.ARMOR_MOVEMENT_SPEED.get(equipmentSlot), "Metallurgy Armor Movement Speed", this.metalStats.getArmorStats().getMovementSpeed() / 4.0, 0));
        }
        return multimap;
    }

    private String getSlotArmorSuffix(EntityEquipmentSlot slot) {
        switch (slot) {
            case HEAD: {
                return "helmet";
            }
            case CHEST: {
                return "chestplate";
            }
            case LEGS: {
                return "leggings";
            }
            case FEET: {
                return "boots";
            }
        }
        return "THIS_CAN'T_POSSIBLY_HAPPEN,_FUCK!";
    }
}

