/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.item.gadget;

import com.google.common.base.Predicate;
import it.hurts.metallurgy_reforged.item.ItemExtra;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import it.hurts.metallurgy_reforged.util.MetallurgyTabs;
import it.hurts.metallurgy_reforged.util.Utils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ItemElectrumMagnet
extends ItemExtra {
    private static final int RADIUS = 6;
    private Status status = Status.DISABLED;

    public ItemElectrumMagnet() {
        super("electrum_magnet", MetallurgyTabs.tabSpecial, "gadget");
        this.func_185043_a(new ResourceLocation("active"), (stack, worldIn, entityIn) -> {
            if (stack.func_77978_p() != null) {
                return stack.func_77978_p().func_74762_e("status") > 0 ? 1.0f : 0.0f;
            }
            return 0.0f;
        });
    }

    @Override
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        if (stack.func_77978_p() != null) {
            Status status = Status.byOrdinal(stack.func_77978_p().func_74762_e("status"));
            tooltip.add("\u00c2\u00a7eAttracts dropped items on the ground (Has 3 different modes)");
            String statusString = Utils.localize("tooltip.metallurgy.electrum_magnet_mode") + " ";
            switch (status) {
                case DISABLED: {
                    statusString = statusString + Utils.localize("tooltip.metallurgy.electrum_magnet_disabled");
                    break;
                }
                case METAL_ONLY: {
                    statusString = statusString + Utils.localize("tooltip.metallurgy.electrum_magnet_metal_only");
                    break;
                }
                case ENABLED: {
                    statusString = statusString + Utils.localize("tooltip.metallurgy.electrum_magnet_enabled");
                }
            }
            tooltip.add(statusString);
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74762_e("status") > 1;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World worldIn, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        ItemStack magnet = playerIn.func_184586_b(handIn);
        if (playerIn.func_70093_af() && magnet.func_77978_p() != null) {
            NBTTagCompound compound = magnet.func_77978_p();
            int status = compound.func_74762_e("status");
            if (status < 2) {
                compound.func_74768_a("status", ++status);
            } else {
                status = 0;
                compound.func_74768_a("status", 0);
            }
            playerIn.field_70170_p.func_184133_a(null, playerIn.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.2f, 0.3f + (float)status / 2.0f * 0.6f);
            magnet.func_77982_d(compound);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77663_a(@Nonnull ItemStack stack, @Nonnull World worldIn, @Nonnull Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        Status status = Status.byOrdinal(stack.func_77978_p().func_74762_e("status"));
        AxisAlignedBB box = new AxisAlignedBB(entityIn.field_70165_t - 6.0, entityIn.field_70163_u - 6.0, entityIn.field_70161_v - 6.0, entityIn.field_70165_t + 6.0, entityIn.field_70163_u + 6.0, entityIn.field_70161_v + 6.0);
        if (status.ordinal() > 0) {
            Predicate predicate = null;
            if (status == Status.METAL_ONLY) {
                predicate = entityItem -> ItemUtils.getMetalFromItem(entityItem.func_92059_d().func_77973_b()) != null || this.isMetal(entityItem.func_92059_d());
            }
            List entItems = worldIn.func_175647_a(EntityItem.class, box, predicate);
            if (!worldIn.field_72995_K) {
                entItems.forEach(item -> {
                    Vec3d itemToPlayerVec = item.func_174791_d().func_72444_a(new Vec3d(entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v)).func_72432_b();
                    item.func_174868_q();
                    item.field_70133_I = true;
                    item.field_70159_w = itemToPlayerVec.field_72450_a * 0.4;
                    item.field_70181_x = itemToPlayerVec.field_72448_b * 0.4;
                    item.field_70179_y = itemToPlayerVec.field_72449_c * 0.4;
                });
            }
        }
    }

    boolean isMetal(ItemStack input) {
        int n = 0;
        int[] ids = OreDictionary.getOreIDs((ItemStack)input);
        int[] nArray = ids;
        int n2 = nArray.length;
        if (n < n2) {
            int id = nArray[n];
            String ore = OreDictionary.getOreName((int)id);
            return ore.contains("ingot") || ore.contains("dust") || ore.contains("ore");
        }
        return false;
    }

    private static enum Status {
        DISABLED,
        METAL_ONLY,
        ENABLED;


        public static Status byOrdinal(int id) {
            return Status.values()[id];
        }
    }
}

