/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.item.gadget.gauntlet;

import it.hurts.metallurgy_reforged.capabilities.punch.IPunchEffect;
import it.hurts.metallurgy_reforged.capabilities.punch.PunchEffectProvider;
import it.hurts.metallurgy_reforged.config.GauntletConfig;
import it.hurts.metallurgy_reforged.item.gadget.gauntlet.GauntletEquipHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.FoodStats;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import scala.util.Random;

public class GauntletEffect {
    @SubscribeEvent
    public static void addPunchEffect(AttackEntityEvent event) {
        EntityPlayer pl = event.getEntityPlayer();
        Entity entity = event.getTarget();
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase entityLivingBase = (EntityLivingBase)entity;
            if (GauntletEquipHandler.isWearingGauntlet((EntityLivingBase)pl) && entityLivingBase.field_70725_aQ <= 0) {
                FoodStats foodStats = pl.func_71024_bL();
                int doubleFoodModifier = GauntletConfig.gauntletHungerModifier * 2;
                if (foodStats.func_75116_a() >= doubleFoodModifier || pl.func_184812_l_()) {
                    IPunchEffect effect = (IPunchEffect)entityLivingBase.getCapability(PunchEffectProvider.PUNCH_EFFECT_CAP, null);
                    if (effect != null && (effect.getHitTicks() <= 0 || effect.getDelayHit() > 0)) {
                        EntityLiving livingEntity;
                        effect.setDelayHit(5);
                        effect.setPunchingPlayer(pl);
                        effect.setRotPitchPlayer(pl.field_70125_A);
                        effect.setRotYawPlayer(pl.func_70079_am());
                        if (entityLivingBase instanceof EntityLiving && !(livingEntity = (EntityLiving)entityLivingBase).func_175446_cd()) {
                            effect.setNoAI(livingEntity.func_175446_cd());
                            livingEntity.func_94061_f(true);
                        }
                    }
                    if (!pl.func_184812_l_() && !pl.field_70170_p.field_72995_K) {
                        int foodDifference = doubleFoodModifier - Math.round(foodStats.func_75115_e());
                        if (foodStats.func_75115_e() <= 0.0f) {
                            foodStats.func_75122_a(-doubleFoodModifier, 0.0f);
                        } else if ((float)foodDifference > 0.0f) {
                            foodStats.func_75122_a(1, -foodStats.func_75115_e());
                            foodStats.func_75122_a(-foodDifference, 0.0f);
                        } else {
                            int foodLevel = foodStats.func_75116_a();
                            foodStats.func_75122_a(1, (float)(-GauntletConfig.gauntletHungerModifier));
                            foodStats.func_75114_a(foodLevel);
                        }
                    }
                    Random rand = new Random();
                    for (int i = 0; i < 20; ++i) {
                        entity.field_70170_p.func_175688_a(EnumParticleTypes.CRIT, entity.field_70165_t + (rand.nextDouble() - 0.5) * ((double)entity.field_70130_N * 1.5), entity.field_70163_u + rand.nextDouble() * ((double)entity.field_70131_O * 1.5), entity.field_70161_v + (rand.nextDouble() - 0.5) * ((double)entity.field_70130_N * 1.5), 0.0, 0.0, 0.0, new int[0]);
                    }
                } else {
                    pl.func_146105_b((ITextComponent)new TextComponentTranslation("effect.metallurgy.punch_effect_tired", new Object[0]), true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void applyPunchThrowEffects(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        IPunchEffect effect = (IPunchEffect)entity.getCapability(PunchEffectProvider.PUNCH_EFFECT_CAP, null);
        if (effect != null) {
            if (effect.getDelayHit() > 0) {
                effect.addHitTicks();
                effect.setDelayHit(effect.getDelayHit() - 1);
                entity.field_70159_w = 0.0;
                entity.field_70181_x = 0.0;
                entity.field_70179_y = 0.0;
                entity.field_70172_ad = 11;
            } else if (effect.getHitTicks() > 0 && entity.field_70725_aQ <= 0) {
                EntityPlayer pl = effect.getPunchingPlayer(entity.field_70170_p);
                if (entity instanceof EntityLiving) {
                    ((EntityLiving)entity).func_94061_f(effect.isAIDisabled());
                }
                if (pl != null) {
                    GauntletEffect.throwEntity(entity);
                }
                effect.setPunchingPlayer(null);
            }
            if (effect.getKnockbackTicks() > 0) {
                entity.field_70159_w = effect.getKnockbackMotionVec().field_72450_a;
                entity.field_70181_x = effect.getKnockbackMotionVec().field_72448_b;
                entity.field_70179_y = effect.getKnockbackMotionVec().field_72449_c;
                Random rand = new Random();
                if (effect.getHitTicks() > 10) {
                    for (int i = 0; i < 20; ++i) {
                        entity.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, entity.field_70165_t + (rand.nextDouble() - 0.5) * ((double)entity.field_70130_N * 1.5), entity.field_70163_u + rand.nextDouble() * ((double)entity.field_70131_O * 1.5), entity.field_70161_v + (rand.nextDouble() - 0.5) * ((double)entity.field_70130_N * 1.5), 0.0, 0.0, 0.0, new int[0]);
                    }
                    AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72314_b(0.4, 0.4, 0.4);
                    if (!entity.field_70128_L && !GauntletConfig.disableBlockGriefing) {
                        for (double i = axisalignedbb.field_72340_a; i < axisalignedbb.field_72336_d; i += 0.1) {
                            for (double j = axisalignedbb.field_72338_b; j < axisalignedbb.field_72337_e; j += 0.1) {
                                for (double k = axisalignedbb.field_72339_c; k < axisalignedbb.field_72334_f; k += 0.1) {
                                    IBlockState state;
                                    float hardness;
                                    BlockPos pos = new BlockPos(i, j, k);
                                    if (entity.field_70170_p.func_175623_d(pos) || !((hardness = (state = entity.field_70170_p.func_180495_p(pos)).func_185887_b(entity.field_70170_p, pos)) >= 0.0f) || state.func_185904_a().func_76224_d()) continue;
                                    if (!entity.field_70170_p.field_72995_K) {
                                        entity.field_70170_p.func_175655_b(pos, true);
                                    }
                                    entity.field_70172_ad = 4;
                                    if (GauntletConfig.gauntletBlockDamageModifier == 0.0) continue;
                                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)entity.func_110144_aD()), (float)GauntletConfig.gauntletBlockDamageModifier);
                                }
                            }
                        }
                    }
                }
                effect.addKnockbackTicks();
                if (effect.getKnockbackTicks() > effect.getHitTicks() / 4) {
                    effect.endEffect(entity);
                }
            }
        }
    }

    private static void throwEntity(EntityLivingBase entity) {
        IPunchEffect effect = (IPunchEffect)entity.getCapability(PunchEffectProvider.PUNCH_EFFECT_CAP, null);
        effect.setKnockbackTicks(1);
    }
}

