/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.item.tool;

import com.google.common.collect.Multimap;
import it.hurts.metallurgy_reforged.config.GeneralConfig;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.item.tool.EnumTools;
import it.hurts.metallurgy_reforged.item.tool.IToolEffect;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.MetalStats;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import it.hurts.metallurgy_reforged.util.MetallurgyTabs;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSwordBase
extends ItemSword
implements IToolEffect {
    private BaseMetallurgyEffect effect;
    private Enchantment enchantment = null;
    private int enchantmentLevel = -1;
    private final MetalStats metalStats;

    public ItemSwordBase(Item.ToolMaterial material, MetalStats metalStats) {
        super(material);
        ItemUtils.initItem((Item)this, metalStats.getName() + "_sword", MetallurgyTabs.tabTool);
        this.metalStats = metalStats;
    }

    @Override
    public EnumTools getToolClass() {
        return EnumTools.SWORD;
    }

    @Override
    public MetalStats getMetalStats() {
        return this.metalStats;
    }

    @Override
    public void setEffect(BaseMetallurgyEffect effect) {
        this.effect = effect;
    }

    public void setEnchanted(Enchantment enchantment, int enchantmentLevel) {
        this.enchantment = enchantment;
        this.enchantmentLevel = enchantmentLevel;
    }

    private ItemStack getRepairStack() {
        String material = this.func_150932_j().toLowerCase();
        Metal metal = ModMetals.metalMap.get(material);
        if (metal != null) {
            return new ItemStack((Item)metal.getIngot());
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_82789_a(ItemStack toRepair, @Nonnull ItemStack repair) {
        return GeneralConfig.enableAnvilToolRepair && ItemUtils.equalsWildcard(this.getRepairStack(), repair) || super.func_82789_a(toRepair, repair);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        if (this.effect != null && this.effect.isEnabled()) {
            tooltip.add(this.effect.getTooltip());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack enchantedSword = new ItemStack((Item)this);
            if (this.enchantment != null) {
                enchantedSword.func_77966_a(this.enchantment, this.enchantmentLevel);
            }
            items.add((Object)enchantedSword);
        }
    }

    @Nonnull
    public Multimap<String, AttributeModifier> func_111205_h(@Nonnull EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        ItemUtils.setToolAttributes(equipmentSlot, (Multimap<String, AttributeModifier>)multimap, this.metalStats);
        return multimap;
    }
}

