/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.material;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.hurts.metallurgy_reforged.Metallurgy;
import it.hurts.metallurgy_reforged.material.ArmorStats;
import it.hurts.metallurgy_reforged.material.MetalStats;
import it.hurts.metallurgy_reforged.material.ToolStats;
import it.hurts.metallurgy_reforged.util.Constants;
import it.hurts.metallurgy_reforged.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.JsonUtils;

public class JsonMaterialHelper {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static final String DEFAULT_CONFIG = "/assets/metallurgy/materials.json";

    public static Set<MetalStats> readConfig(String resourcePath, Set<MetalStats> defaultStats) throws JsonSyntaxException {
        HashSet<MetalStats> metalStats = new HashSet<MetalStats>();
        try {
            Path path = resourcePath.equals(DEFAULT_CONFIG) ? Utils.getPath(resourcePath) : new File(Metallurgy.materialConfig).toPath();
            BufferedReader reader = Files.newBufferedReader(path);
            JsonArray materials = (JsonArray)JsonUtils.func_193839_a((Gson)gson, (Reader)reader, JsonArray.class);
            if (materials != null) {
                materials.forEach(jsonElement -> {
                    JsonObject jsonMetal;
                    JsonObject jsonObject = jsonMetal = jsonElement.isJsonObject() ? jsonElement.getAsJsonObject() : null;
                    if (jsonMetal != null) {
                        MetalStats metalStat = JsonMaterialHelper.readMetalFromJson(jsonMetal, defaultStats);
                        metalStats.add(metalStat);
                    }
                });
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return metalStats;
    }

    private static MetalStats readMetalFromJson(JsonObject metalObj, Set<MetalStats> defaultStats) throws JsonSyntaxException {
        if (!metalObj.has("name")) {
            return null;
        }
        String name = JsonUtils.func_151200_h((JsonObject)metalObj, (String)"name");
        MetalStats defaultStat = JsonMaterialHelper.getMetalStatsByName(name, defaultStats);
        float hardness = JsonUtils.func_151221_a((JsonObject)metalObj, (String)"hardness", (float)defaultStat.getHardness());
        float blockBlastResistance = JsonUtils.func_151221_a((JsonObject)metalObj, (String)"blast_resistance", (float)defaultStat.getHardness());
        int oreHarvest = JsonUtils.func_151208_a((JsonObject)metalObj, (String)"ore_harvest_level", (int)defaultStat.getOreHarvest());
        int color = Integer.parseInt(JsonUtils.func_151219_a((JsonObject)metalObj, (String)"color", (String)String.valueOf(defaultStat.getColorHex())), 16);
        ArmorStats armorStats = JsonMaterialHelper.getArmorStats(metalObj, defaultStat.getArmorStats());
        ToolStats toolStats = JsonMaterialHelper.getToolStats(metalObj, defaultStat.getToolStats());
        return new MetalStats(name, hardness, blockBlastResistance, armorStats, toolStats, oreHarvest, color);
    }

    private static MetalStats getMetalStatsByName(String name, Set<MetalStats> defaultStats) throws JsonSyntaxException {
        if (defaultStats != null) {
            for (MetalStats stat : defaultStats) {
                if (!stat.getName().equals(name)) continue;
                return stat;
            }
        }
        return Constants.EMPTY_METAL_STATS;
    }

    private static ArmorStats getArmorStats(JsonObject metalStats, ArmorStats fallback) throws JsonSyntaxException {
        if (metalStats.has("armor_stats")) {
            JsonObject armorStatsObj = JsonUtils.func_152754_s((JsonObject)metalStats, (String)"armor_stats");
            int enchantability = JsonUtils.func_151208_a((JsonObject)armorStatsObj, (String)"enchantability", (int)fallback.getEnchantability());
            int durability = JsonUtils.func_151208_a((JsonObject)armorStatsObj, (String)"durability", (int)fallback.getDurability());
            float toughness = JsonUtils.func_151221_a((JsonObject)armorStatsObj, (String)"toughness", (float)fallback.getToughness());
            int[] damageReduction = JsonMaterialHelper.getIntArray(armorStatsObj, "damage_reduction", fallback.getDamageReduction());
            double maxHealth = JsonUtils.func_151221_a((JsonObject)armorStatsObj, (String)"max_health", (float)((float)fallback.getMaxHealth()));
            double knockbackResistance = JsonUtils.func_151221_a((JsonObject)armorStatsObj, (String)"knockback_resistance", (float)((float)fallback.getKnockbackResistance()));
            double movementSpeed = JsonUtils.func_151221_a((JsonObject)armorStatsObj, (String)"movement_speed", (float)((float)fallback.getMovementSpeed()));
            ArmorStats armorStats = new ArmorStats(damageReduction, enchantability, durability, toughness);
            armorStats.setAttributes(maxHealth, knockbackResistance, movementSpeed);
            return armorStats;
        }
        return null;
    }

    private static ToolStats getToolStats(JsonObject metalStats, ToolStats fallback) throws JsonSyntaxException {
        if (metalStats.has("tool_stats")) {
            JsonObject toolStatsObj = JsonUtils.func_152754_s((JsonObject)metalStats, (String)"tool_stats");
            float efficiency = JsonUtils.func_151221_a((JsonObject)toolStatsObj, (String)"efficiency", (float)fallback.getEfficiency());
            int harvestLevel = JsonUtils.func_151208_a((JsonObject)toolStatsObj, (String)"harvest_level", (int)fallback.getHarvestLevel());
            int enchantability = JsonUtils.func_151208_a((JsonObject)toolStatsObj, (String)"enchantability", (int)fallback.getToolMagic());
            int durability = JsonUtils.func_151208_a((JsonObject)toolStatsObj, (String)"durability", (int)fallback.getMaxUses());
            float damage = JsonUtils.func_151221_a((JsonObject)toolStatsObj, (String)"damage", (float)fallback.getDamage());
            double maxHealth = JsonUtils.func_151221_a((JsonObject)toolStatsObj, (String)"max_health", (float)((float)fallback.getMaxHealth()));
            double movementSpeed = JsonUtils.func_151221_a((JsonObject)toolStatsObj, (String)"movement_speed", (float)((float)fallback.getMovementSpeed()));
            double attackDamage = JsonUtils.func_151221_a((JsonObject)toolStatsObj, (String)"attack_damage", (float)((float)fallback.getAttackDamageAttribute()));
            double attackSpeed = JsonUtils.func_151221_a((JsonObject)toolStatsObj, (String)"attack_speed", (float)((float)fallback.getAttackSpeed()));
            double reachDistance = JsonUtils.func_151221_a((JsonObject)toolStatsObj, (String)"reach_distance", (float)((float)fallback.getReachDistance()));
            ToolStats toolStats = new ToolStats(enchantability, harvestLevel, durability, efficiency, damage);
            toolStats.setAttributes(maxHealth, movementSpeed, attackDamage, attackSpeed, reachDistance);
            return toolStats;
        }
        return null;
    }

    private static int[] getIntArray(JsonObject json, String memberName, int[] fallback) throws JsonSyntaxException {
        int[] arr = new int[4];
        if (json.has(memberName)) {
            JsonArray jsonArray = json.getAsJsonArray(memberName);
            for (int i = 0; i < arr.length; ++i) {
                JsonElement element = jsonArray.get(i);
                arr[i] = JsonUtils.func_188175_b((JsonElement)element) ? element.getAsInt() : fallback[i];
            }
        }
        return arr;
    }
}

