/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.material;

import it.hurts.metallurgy_reforged.block.BlockMetal;
import it.hurts.metallurgy_reforged.block.BlockOre;
import it.hurts.metallurgy_reforged.block.BlockTypes;
import it.hurts.metallurgy_reforged.fluid.FluidMolten;
import it.hurts.metallurgy_reforged.item.ItemMetal;
import it.hurts.metallurgy_reforged.item.armor.ItemArmorBase;
import it.hurts.metallurgy_reforged.item.tool.EnumTools;
import it.hurts.metallurgy_reforged.material.MetalStats;
import it.hurts.metallurgy_reforged.material.ModMetals;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;

public class Metal {
    private final MetalStats stats;
    private final ItemMetal ingot;
    private final ItemMetal dust;
    private final ItemMetal nugget;
    private final BlockOre ore;
    private final BlockMetal[] blocks;
    private final Item[] toolSet;
    private final ItemArmorBase[] armorSet;
    private final FluidMolten molten;

    public Metal(@Nonnull MetalStats stats, @Nonnull ItemMetal ingot, @Nonnull ItemMetal dust, @Nonnull ItemMetal nugget, BlockOre ore, @Nonnull BlockMetal[] blocks, @Nonnull FluidMolten molten, Item[] toolSet, ItemArmorBase[] armorSet) {
        this.stats = stats;
        this.ingot = ingot;
        this.dust = dust;
        this.nugget = nugget;
        this.ore = ore;
        this.blocks = blocks;
        this.molten = molten;
        this.toolSet = toolSet;
        this.armorSet = armorSet;
        ModMetals.metalMap.put(stats.getName(), this);
        try {
            ModMetals.class.getDeclaredField(stats.getName().toUpperCase()).set(null, this);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public Item.ToolMaterial getToolMaterial() {
        return this.stats.getToolMaterial();
    }

    public ItemArmor.ArmorMaterial getArmorMaterial() {
        return this.stats.getArmorMaterial();
    }

    public boolean hasToolSet() {
        return this.stats.getToolStats() != null;
    }

    public boolean hasArmorSet() {
        return this.stats.getArmorStats() != null;
    }

    public boolean isAlloy() {
        return this.ore == null;
    }

    @Nonnull
    public MetalStats getStats() {
        return this.stats;
    }

    @Nonnull
    public ItemMetal getIngot() {
        return this.ingot;
    }

    @Nonnull
    public ItemMetal getDust() {
        return this.dust;
    }

    @Nonnull
    public ItemMetal getNugget() {
        return this.nugget;
    }

    @Nullable
    public BlockOre getOre() {
        return this.ore;
    }

    @Nonnull
    public BlockMetal[] getBlocks() {
        return this.blocks;
    }

    @Nonnull
    public BlockMetal getBlock(BlockTypes type) {
        return this.blocks[type.ordinal()];
    }

    @Nonnull
    public FluidMolten getMolten() {
        return this.molten;
    }

    public Item getTool(EnumTools toolClass) {
        return this.toolSet[toolClass.ordinal()];
    }

    public ItemArmorBase getArmorPiece(EntityEquipmentSlot armorPiece) {
        return armorPiece.func_188453_a() == EntityEquipmentSlot.Type.ARMOR ? this.armorSet[3 - armorPiece.func_188454_b()] : null;
    }

    @Nullable
    public Item[] getToolSet() {
        return this.toolSet;
    }

    @Nullable
    public ItemArmorBase[] getArmorSet() {
        return this.armorSet;
    }

    public String toString() {
        return this.stats.getName();
    }
}

